package zio.aws.kafka.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kafka.model.primitives.__integerMin1Max16384
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EBSStorageInfo(
    volumeSize: Option[__integerMin1Max16384] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.EBSStorageInfo = {
    import EBSStorageInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.EBSStorageInfo
      .builder()
      .optionallyWith(
        volumeSize.map(value => __integerMin1Max16384.unwrap(value): Integer)
      )(_.volumeSize)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.EBSStorageInfo.ReadOnly =
    zio.aws.kafka.model.EBSStorageInfo.wrap(buildAwsValue())
}
object EBSStorageInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.EBSStorageInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.EBSStorageInfo =
      zio.aws.kafka.model.EBSStorageInfo(volumeSize.map(value => value))
    def volumeSize: Option[__integerMin1Max16384]
    def getVolumeSize: ZIO[Any, AwsError, __integerMin1Max16384] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.EBSStorageInfo
  ) extends zio.aws.kafka.model.EBSStorageInfo.ReadOnly {
    override val volumeSize: Option[__integerMin1Max16384] = scala
      .Option(impl.volumeSize())
      .map(value => zio.aws.kafka.model.primitives.__integerMin1Max16384(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.EBSStorageInfo
  ): zio.aws.kafka.model.EBSStorageInfo.ReadOnly = new Wrapper(impl)
}
