package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__long, __string}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ConfigurationInfo(arn: __string, revision: __long) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ConfigurationInfo = {
    import ConfigurationInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ConfigurationInfo
      .builder()
      .arn(__string.unwrap(arn): java.lang.String)
      .revision(__long.unwrap(revision): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ConfigurationInfo.ReadOnly =
    zio.aws.kafka.model.ConfigurationInfo.wrap(buildAwsValue())
}
object ConfigurationInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ConfigurationInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ConfigurationInfo =
      zio.aws.kafka.model.ConfigurationInfo(arn, revision)
    def arn: __string
    def revision: __long
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getRevision: ZIO[Any, Nothing, __long] = ZIO.succeed(revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ConfigurationInfo
  ) extends zio.aws.kafka.model.ConfigurationInfo.ReadOnly {
    override val arn: __string =
      zio.aws.kafka.model.primitives.__string(impl.arn())
    override val revision: __long =
      zio.aws.kafka.model.primitives.__long(impl.revision())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ConfigurationInfo
  ): zio.aws.kafka.model.ConfigurationInfo.ReadOnly = new Wrapper(impl)
}
