package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__timestampIso8601, __string}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Configuration(
    arn: __string,
    creationTime: __timestampIso8601,
    description: __string,
    kafkaVersions: Iterable[__string],
    latestRevision: zio.aws.kafka.model.ConfigurationRevision,
    name: __string,
    state: zio.aws.kafka.model.ConfigurationState
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.Configuration = {
    import Configuration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.Configuration
      .builder()
      .arn(__string.unwrap(arn): java.lang.String)
      .creationTime(__timestampIso8601.unwrap(creationTime): Instant)
      .description(__string.unwrap(description): java.lang.String)
      .kafkaVersions(kafkaVersions.map { item =>
        __string.unwrap(item): java.lang.String
      }.asJavaCollection)
      .latestRevision(latestRevision.buildAwsValue())
      .name(__string.unwrap(name): java.lang.String)
      .state(state.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.Configuration.ReadOnly =
    zio.aws.kafka.model.Configuration.wrap(buildAwsValue())
}
object Configuration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.Configuration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.Configuration =
      zio.aws.kafka.model.Configuration(
        arn,
        creationTime,
        description,
        kafkaVersions,
        latestRevision.asEditable,
        name,
        state
      )
    def arn: __string
    def creationTime: __timestampIso8601
    def description: __string
    def kafkaVersions: List[__string]
    def latestRevision: zio.aws.kafka.model.ConfigurationRevision.ReadOnly
    def name: __string
    def state: zio.aws.kafka.model.ConfigurationState
    def getArn: ZIO[Any, Nothing, __string] = ZIO.succeed(arn)
    def getCreationTime: ZIO[Any, Nothing, __timestampIso8601] =
      ZIO.succeed(creationTime)
    def getDescription: ZIO[Any, Nothing, __string] = ZIO.succeed(description)
    def getKafkaVersions: ZIO[Any, Nothing, List[__string]] =
      ZIO.succeed(kafkaVersions)
    def getLatestRevision: ZIO[
      Any,
      Nothing,
      zio.aws.kafka.model.ConfigurationRevision.ReadOnly
    ] = ZIO.succeed(latestRevision)
    def getName: ZIO[Any, Nothing, __string] = ZIO.succeed(name)
    def getState: ZIO[Any, Nothing, zio.aws.kafka.model.ConfigurationState] =
      ZIO.succeed(state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.Configuration
  ) extends zio.aws.kafka.model.Configuration.ReadOnly {
    override val arn: __string =
      zio.aws.kafka.model.primitives.__string(impl.arn())
    override val creationTime: __timestampIso8601 =
      zio.aws.kafka.model.primitives.__timestampIso8601(impl.creationTime())
    override val description: __string =
      zio.aws.kafka.model.primitives.__string(impl.description())
    override val kafkaVersions: List[__string] = impl
      .kafkaVersions()
      .asScala
      .map { item =>
        zio.aws.kafka.model.primitives.__string(item)
      }
      .toList
    override val latestRevision
        : zio.aws.kafka.model.ConfigurationRevision.ReadOnly =
      zio.aws.kafka.model.ConfigurationRevision.wrap(impl.latestRevision())
    override val name: __string =
      zio.aws.kafka.model.primitives.__string(impl.name())
    override val state: zio.aws.kafka.model.ConfigurationState =
      zio.aws.kafka.model.ConfigurationState.wrap(impl.state())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.Configuration
  ): zio.aws.kafka.model.Configuration.ReadOnly = new Wrapper(impl)
}
