package zio.aws.kafka.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kafka.model.primitives.{__integer, __string}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BrokerEBSVolumeInfo(
    kafkaBrokerNodeId: __string,
    volumeSizeGB: __integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo = {
    import BrokerEBSVolumeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo
      .builder()
      .kafkaBrokerNodeId(__string.unwrap(kafkaBrokerNodeId): java.lang.String)
      .volumeSizeGB(__integer.unwrap(volumeSizeGB): Integer)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.BrokerEBSVolumeInfo.ReadOnly =
    zio.aws.kafka.model.BrokerEBSVolumeInfo.wrap(buildAwsValue())
}
object BrokerEBSVolumeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.BrokerEBSVolumeInfo =
      zio.aws.kafka.model.BrokerEBSVolumeInfo(kafkaBrokerNodeId, volumeSizeGB)
    def kafkaBrokerNodeId: __string
    def volumeSizeGB: __integer
    def getKafkaBrokerNodeId: ZIO[Any, Nothing, __string] =
      ZIO.succeed(kafkaBrokerNodeId)
    def getVolumeSizeGB: ZIO[Any, Nothing, __integer] =
      ZIO.succeed(volumeSizeGB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo
  ) extends zio.aws.kafka.model.BrokerEBSVolumeInfo.ReadOnly {
    override val kafkaBrokerNodeId: __string =
      zio.aws.kafka.model.primitives.__string(impl.kafkaBrokerNodeId())
    override val volumeSizeGB: __integer =
      zio.aws.kafka.model.primitives.__integer(impl.volumeSizeGB())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.BrokerEBSVolumeInfo
  ): zio.aws.kafka.model.BrokerEBSVolumeInfo.ReadOnly = new Wrapper(impl)
}
