package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CompatibleKafkaVersion(
    sourceVersion: Option[__string] = None,
    targetVersions: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CompatibleKafkaVersion = {
    import CompatibleKafkaVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CompatibleKafkaVersion
      .builder()
      .optionallyWith(
        sourceVersion.map(value => __string.unwrap(value): java.lang.String)
      )(_.sourceVersion)
      .optionallyWith(
        targetVersions.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetVersions)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CompatibleKafkaVersion.ReadOnly =
    zio.aws.kafka.model.CompatibleKafkaVersion.wrap(buildAwsValue())
}
object CompatibleKafkaVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CompatibleKafkaVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CompatibleKafkaVersion =
      zio.aws.kafka.model.CompatibleKafkaVersion(
        sourceVersion.map(value => value),
        targetVersions.map(value => value)
      )
    def sourceVersion: Option[__string]
    def targetVersions: Option[List[__string]]
    def getSourceVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
    def getTargetVersions: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("targetVersions", targetVersions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CompatibleKafkaVersion
  ) extends zio.aws.kafka.model.CompatibleKafkaVersion.ReadOnly {
    override val sourceVersion: Option[__string] = scala
      .Option(impl.sourceVersion())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val targetVersions: Option[List[__string]] = scala
      .Option(impl.targetVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kafka.model.primitives.__string(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CompatibleKafkaVersion
  ): zio.aws.kafka.model.CompatibleKafkaVersion.ReadOnly = new Wrapper(impl)
}
