package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UnprocessedScramSecret(
    errorCode: Option[__string] = None,
    errorMessage: Option[__string] = None,
    secretArn: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UnprocessedScramSecret = {
    import UnprocessedScramSecret.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UnprocessedScramSecret
      .builder()
      .optionallyWith(
        errorCode.map(value => __string.unwrap(value): java.lang.String)
      )(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => __string.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        secretArn.map(value => __string.unwrap(value): java.lang.String)
      )(_.secretArn)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UnprocessedScramSecret.ReadOnly =
    zio.aws.kafka.model.UnprocessedScramSecret.wrap(buildAwsValue())
}
object UnprocessedScramSecret {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UnprocessedScramSecret
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UnprocessedScramSecret =
      zio.aws.kafka.model.UnprocessedScramSecret(
        errorCode.map(value => value),
        errorMessage.map(value => value),
        secretArn.map(value => value)
      )
    def errorCode: Option[__string]
    def errorMessage: Option[__string]
    def secretArn: Option[__string]
    def getErrorCode: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getSecretArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("secretArn", secretArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UnprocessedScramSecret
  ) extends zio.aws.kafka.model.UnprocessedScramSecret.ReadOnly {
    override val errorCode: Option[__string] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val errorMessage: Option[__string] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val secretArn: Option[__string] = scala
      .Option(impl.secretArn())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UnprocessedScramSecret
  ): zio.aws.kafka.model.UnprocessedScramSecret.ReadOnly = new Wrapper(impl)
}
