package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListScramSecretsResponse(
    nextToken: Option[__string] = None,
    secretArnList: Option[Iterable[__string]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListScramSecretsResponse = {
    import ListScramSecretsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListScramSecretsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => __string.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        secretArnList.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.secretArnList)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListScramSecretsResponse.ReadOnly =
    zio.aws.kafka.model.ListScramSecretsResponse.wrap(buildAwsValue())
}
object ListScramSecretsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListScramSecretsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListScramSecretsResponse =
      zio.aws.kafka.model.ListScramSecretsResponse(
        nextToken.map(value => value),
        secretArnList.map(value => value)
      )
    def nextToken: Option[__string]
    def secretArnList: Option[List[__string]]
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSecretArnList: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField("secretArnList", secretArnList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListScramSecretsResponse
  ) extends zio.aws.kafka.model.ListScramSecretsResponse.ReadOnly {
    override val nextToken: Option[__string] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kafka.model.primitives.__string(value))
    override val secretArnList: Option[List[__string]] = scala
      .Option(impl.secretArnList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kafka.model.primitives.__string(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListScramSecretsResponse
  ): zio.aws.kafka.model.ListScramSecretsResponse.ReadOnly = new Wrapper(impl)
}
