package zio.aws.ivsrealtime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivsrealtime.model.primitives.{
  ParticipantTokenExpirationTime,
  ParticipantTokenDurationMinutes,
  ParticipantTokenUserId,
  ParticipantTokenString,
  ParticipantTokenId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ParticipantToken(
    attributes: Optional[Map[String, String]] = Optional.Absent,
    capabilities: Optional[
      Iterable[zio.aws.ivsrealtime.model.ParticipantTokenCapability]
    ] = Optional.Absent,
    duration: Optional[ParticipantTokenDurationMinutes] = Optional.Absent,
    expirationTime: Optional[ParticipantTokenExpirationTime] = Optional.Absent,
    participantId: Optional[ParticipantTokenId] = Optional.Absent,
    token: Optional[ParticipantTokenString] = Optional.Absent,
    userId: Optional[ParticipantTokenUserId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.ParticipantToken = {
    import ParticipantToken.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.ParticipantToken
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        duration.map(value =>
          ParticipantTokenDurationMinutes.unwrap(value): Integer
        )
      )(_.duration)
      .optionallyWith(
        expirationTime.map(value =>
          ParticipantTokenExpirationTime.unwrap(value): Instant
        )
      )(_.expirationTime)
      .optionallyWith(
        participantId.map(value =>
          ParticipantTokenId.unwrap(value): java.lang.String
        )
      )(_.participantId)
      .optionallyWith(
        token.map(value =>
          ParticipantTokenString.unwrap(value): java.lang.String
        )
      )(_.token)
      .optionallyWith(
        userId.map(value =>
          ParticipantTokenUserId.unwrap(value): java.lang.String
        )
      )(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.ParticipantToken.ReadOnly =
    zio.aws.ivsrealtime.model.ParticipantToken.wrap(buildAwsValue())
}
object ParticipantToken {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.ParticipantToken
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.ParticipantToken =
      zio.aws.ivsrealtime.model.ParticipantToken(
        attributes.map(value => value),
        capabilities.map(value => value),
        duration.map(value => value),
        expirationTime.map(value => value),
        participantId.map(value => value),
        token.map(value => value),
        userId.map(value => value)
      )
    def attributes: Optional[Map[String, String]]
    def capabilities
        : Optional[List[zio.aws.ivsrealtime.model.ParticipantTokenCapability]]
    def duration: Optional[ParticipantTokenDurationMinutes]
    def expirationTime: Optional[ParticipantTokenExpirationTime]
    def participantId: Optional[ParticipantTokenId]
    def token: Optional[ParticipantTokenString]
    def userId: Optional[ParticipantTokenUserId]
    def getAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getCapabilities: ZIO[Any, AwsError, List[
      zio.aws.ivsrealtime.model.ParticipantTokenCapability
    ]] = AwsError.unwrapOptionField("capabilities", capabilities)
    def getDuration: ZIO[Any, AwsError, ParticipantTokenDurationMinutes] =
      AwsError.unwrapOptionField("duration", duration)
    def getExpirationTime: ZIO[Any, AwsError, ParticipantTokenExpirationTime] =
      AwsError.unwrapOptionField("expirationTime", expirationTime)
    def getParticipantId: ZIO[Any, AwsError, ParticipantTokenId] =
      AwsError.unwrapOptionField("participantId", participantId)
    def getToken: ZIO[Any, AwsError, ParticipantTokenString] =
      AwsError.unwrapOptionField("token", token)
    def getUserId: ZIO[Any, AwsError, ParticipantTokenUserId] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ParticipantToken
  ) extends zio.aws.ivsrealtime.model.ParticipantToken.ReadOnly {
    override val attributes: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val capabilities
        : Optional[List[zio.aws.ivsrealtime.model.ParticipantTokenCapability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ivsrealtime.model.ParticipantTokenCapability.wrap(item)
          }.toList
        )
    override val duration: Optional[ParticipantTokenDurationMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.duration())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives
            .ParticipantTokenDurationMinutes(value)
        )
    override val expirationTime: Optional[ParticipantTokenExpirationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expirationTime())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives
            .ParticipantTokenExpirationTime(value)
        )
    override val participantId: Optional[ParticipantTokenId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participantId())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives.ParticipantTokenId(value)
        )
    override val token: Optional[ParticipantTokenString] = zio.aws.core.internal
      .optionalFromNullable(impl.token())
      .map(value =>
        zio.aws.ivsrealtime.model.primitives.ParticipantTokenString(value)
      )
    override val userId: Optional[ParticipantTokenUserId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userId())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives.ParticipantTokenUserId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ParticipantToken
  ): zio.aws.ivsrealtime.model.ParticipantToken.ReadOnly = new Wrapper(impl)
}
