package zio.aws.ivsrealtime.model
import zio.aws.ivsrealtime.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStagesResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    stages: Iterable[zio.aws.ivsrealtime.model.StageSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.ListStagesResponse = {
    import ListStagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.ListStagesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .stages(stages.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.ListStagesResponse.ReadOnly =
    zio.aws.ivsrealtime.model.ListStagesResponse.wrap(buildAwsValue())
}
object ListStagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.ListStagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.ListStagesResponse =
      zio.aws.ivsrealtime.model.ListStagesResponse(
        nextToken.map(value => value),
        stages.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[PaginationToken]
    def stages: List[zio.aws.ivsrealtime.model.StageSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStages: ZIO[Any, Nothing, List[
      zio.aws.ivsrealtime.model.StageSummary.ReadOnly
    ]] = ZIO.succeed(stages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListStagesResponse
  ) extends zio.aws.ivsrealtime.model.ListStagesResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivsrealtime.model.primitives.PaginationToken(value))
    override val stages: List[zio.aws.ivsrealtime.model.StageSummary.ReadOnly] =
      impl
        .stages()
        .asScala
        .map { item =>
          zio.aws.ivsrealtime.model.StageSummary.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListStagesResponse
  ): zio.aws.ivsrealtime.model.ListStagesResponse.ReadOnly = new Wrapper(impl)
}
