package zio.aws.ivsrealtime.model
import zio.aws.ivsrealtime.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStageSessionsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    stageSessions: Iterable[zio.aws.ivsrealtime.model.StageSessionSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsResponse = {
    import ListStageSessionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .stageSessions(stageSessions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.ListStageSessionsResponse.ReadOnly =
    zio.aws.ivsrealtime.model.ListStageSessionsResponse.wrap(buildAwsValue())
}
object ListStageSessionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.ListStageSessionsResponse =
      zio.aws.ivsrealtime.model.ListStageSessionsResponse(
        nextToken.map(value => value),
        stageSessions.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[PaginationToken]
    def stageSessions
        : List[zio.aws.ivsrealtime.model.StageSessionSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStageSessions: ZIO[Any, Nothing, List[
      zio.aws.ivsrealtime.model.StageSessionSummary.ReadOnly
    ]] = ZIO.succeed(stageSessions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsResponse
  ) extends zio.aws.ivsrealtime.model.ListStageSessionsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivsrealtime.model.primitives.PaginationToken(value))
    override val stageSessions
        : List[zio.aws.ivsrealtime.model.StageSessionSummary.ReadOnly] = impl
      .stageSessions()
      .asScala
      .map { item =>
        zio.aws.ivsrealtime.model.StageSessionSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsResponse
  ): zio.aws.ivsrealtime.model.ListStageSessionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
