package zio.aws.ivsrealtime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivsrealtime.model.primitives.{
  StageArn,
  PaginationToken,
  MaxStageSessionResults
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStageSessionsRequest(
    maxResults: Optional[MaxStageSessionResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    stageArn: StageArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsRequest = {
    import ListStageSessionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxStageSessionResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .stageArn(StageArn.unwrap(stageArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.ListStageSessionsRequest.ReadOnly =
    zio.aws.ivsrealtime.model.ListStageSessionsRequest.wrap(buildAwsValue())
}
object ListStageSessionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.ListStageSessionsRequest =
      zio.aws.ivsrealtime.model.ListStageSessionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        stageArn
      )
    def maxResults: Optional[MaxStageSessionResults]
    def nextToken: Optional[PaginationToken]
    def stageArn: StageArn
    def getMaxResults: ZIO[Any, AwsError, MaxStageSessionResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStageArn: ZIO[Any, Nothing, StageArn] = ZIO.succeed(stageArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsRequest
  ) extends zio.aws.ivsrealtime.model.ListStageSessionsRequest.ReadOnly {
    override val maxResults: Optional[MaxStageSessionResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives.MaxStageSessionResults(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivsrealtime.model.primitives.PaginationToken(value))
    override val stageArn: StageArn =
      zio.aws.ivsrealtime.model.primitives.StageArn(impl.stageArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListStageSessionsRequest
  ): zio.aws.ivsrealtime.model.ListStageSessionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
