package zio.aws.ivsrealtime.model
import zio.aws.ivsrealtime.model.primitives.{StageArn, StageSessionId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetStageSessionRequest(
    sessionId: StageSessionId,
    stageArn: StageArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.GetStageSessionRequest = {
    import GetStageSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.GetStageSessionRequest
      .builder()
      .sessionId(StageSessionId.unwrap(sessionId): java.lang.String)
      .stageArn(StageArn.unwrap(stageArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.GetStageSessionRequest.ReadOnly =
    zio.aws.ivsrealtime.model.GetStageSessionRequest.wrap(buildAwsValue())
}
object GetStageSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.GetStageSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.GetStageSessionRequest =
      zio.aws.ivsrealtime.model.GetStageSessionRequest(sessionId, stageArn)
    def sessionId: StageSessionId
    def stageArn: StageArn
    def getSessionId: ZIO[Any, Nothing, StageSessionId] = ZIO.succeed(sessionId)
    def getStageArn: ZIO[Any, Nothing, StageArn] = ZIO.succeed(stageArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.GetStageSessionRequest
  ) extends zio.aws.ivsrealtime.model.GetStageSessionRequest.ReadOnly {
    override val sessionId: StageSessionId =
      zio.aws.ivsrealtime.model.primitives.StageSessionId(impl.sessionId())
    override val stageArn: StageArn =
      zio.aws.ivsrealtime.model.primitives.StageArn(impl.stageArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.GetStageSessionRequest
  ): zio.aws.ivsrealtime.model.GetStageSessionRequest.ReadOnly = new Wrapper(
    impl
  )
}
