package zio.aws.ivsrealtime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetStageResponse(
    stage: Optional[zio.aws.ivsrealtime.model.Stage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.GetStageResponse = {
    import GetStageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.GetStageResponse
      .builder()
      .optionallyWith(stage.map(value => value.buildAwsValue()))(_.stage)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.GetStageResponse.ReadOnly =
    zio.aws.ivsrealtime.model.GetStageResponse.wrap(buildAwsValue())
}
object GetStageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.GetStageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.GetStageResponse =
      zio.aws.ivsrealtime.model
        .GetStageResponse(stage.map(value => value.asEditable))
    def stage: Optional[zio.aws.ivsrealtime.model.Stage.ReadOnly]
    def getStage: ZIO[Any, AwsError, zio.aws.ivsrealtime.model.Stage.ReadOnly] =
      AwsError.unwrapOptionField("stage", stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.GetStageResponse
  ) extends zio.aws.ivsrealtime.model.GetStageResponse.ReadOnly {
    override val stage: Optional[zio.aws.ivsrealtime.model.Stage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stage())
        .map(value => zio.aws.ivsrealtime.model.Stage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.GetStageResponse
  ): zio.aws.ivsrealtime.model.GetStageResponse.ReadOnly = new Wrapper(impl)
}
