package zio.aws.ivsrealtime.model
import zio.aws.ivsrealtime.model.primitives.StageArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetStageRequest(arn: StageArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.GetStageRequest = {
    import GetStageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.GetStageRequest
      .builder()
      .arn(StageArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.GetStageRequest.ReadOnly =
    zio.aws.ivsrealtime.model.GetStageRequest.wrap(buildAwsValue())
}
object GetStageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.GetStageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.GetStageRequest =
      zio.aws.ivsrealtime.model.GetStageRequest(arn)
    def arn: StageArn
    def getArn: ZIO[Any, Nothing, StageArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.GetStageRequest
  ) extends zio.aws.ivsrealtime.model.GetStageRequest.ReadOnly {
    override val arn: StageArn =
      zio.aws.ivsrealtime.model.primitives.StageArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.GetStageRequest
  ): zio.aws.ivsrealtime.model.GetStageRequest.ReadOnly = new Wrapper(impl)
}
