package zio.aws.ivsrealtime.model
import scala.jdk.CollectionConverters._
sealed trait EventName {
  def unwrap: software.amazon.awssdk.services.ivsrealtime.model.EventName
}
object EventName {
  def wrap(
      value: software.amazon.awssdk.services.ivsrealtime.model.EventName
  ): zio.aws.ivsrealtime.model.EventName = value match {
    case software.amazon.awssdk.services.ivsrealtime.model.EventName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivsrealtime.model.EventName.JOINED =>
      val r = JOINED
      r
    case software.amazon.awssdk.services.ivsrealtime.model.EventName.LEFT =>
      val r = LEFT
      r
    case software.amazon.awssdk.services.ivsrealtime.model.EventName.PUBLISH_STARTED =>
      val r = PUBLISH_STARTED
      r
    case software.amazon.awssdk.services.ivsrealtime.model.EventName.PUBLISH_STOPPED =>
      val r = PUBLISH_STOPPED
      r
    case software.amazon.awssdk.services.ivsrealtime.model.EventName.SUBSCRIBE_STARTED =>
      val r = SUBSCRIBE_STARTED
      r
    case software.amazon.awssdk.services.ivsrealtime.model.EventName.SUBSCRIBE_STOPPED =>
      val r = SUBSCRIBE_STOPPED
      r
    case software.amazon.awssdk.services.ivsrealtime.model.EventName.PUBLISH_ERROR =>
      val r = PUBLISH_ERROR
      r
    case software.amazon.awssdk.services.ivsrealtime.model.EventName.SUBSCRIBE_ERROR =>
      val r = SUBSCRIBE_ERROR
      r
    case software.amazon.awssdk.services.ivsrealtime.model.EventName.JOIN_ERROR =>
      val r = JOIN_ERROR
      r
  }
  case object unknownToSdkVersion extends zio.aws.ivsrealtime.model.EventName {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.EventName =
      software.amazon.awssdk.services.ivsrealtime.model.EventName.UNKNOWN_TO_SDK_VERSION
  }
  case object JOINED extends zio.aws.ivsrealtime.model.EventName {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.EventName =
      software.amazon.awssdk.services.ivsrealtime.model.EventName.JOINED
  }
  case object LEFT extends zio.aws.ivsrealtime.model.EventName {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.EventName =
      software.amazon.awssdk.services.ivsrealtime.model.EventName.LEFT
  }
  case object PUBLISH_STARTED extends zio.aws.ivsrealtime.model.EventName {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.EventName =
      software.amazon.awssdk.services.ivsrealtime.model.EventName.PUBLISH_STARTED
  }
  case object PUBLISH_STOPPED extends zio.aws.ivsrealtime.model.EventName {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.EventName =
      software.amazon.awssdk.services.ivsrealtime.model.EventName.PUBLISH_STOPPED
  }
  case object SUBSCRIBE_STARTED extends zio.aws.ivsrealtime.model.EventName {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.EventName =
      software.amazon.awssdk.services.ivsrealtime.model.EventName.SUBSCRIBE_STARTED
  }
  case object SUBSCRIBE_STOPPED extends zio.aws.ivsrealtime.model.EventName {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.EventName =
      software.amazon.awssdk.services.ivsrealtime.model.EventName.SUBSCRIBE_STOPPED
  }
  case object PUBLISH_ERROR extends zio.aws.ivsrealtime.model.EventName {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.EventName =
      software.amazon.awssdk.services.ivsrealtime.model.EventName.PUBLISH_ERROR
  }
  case object SUBSCRIBE_ERROR extends zio.aws.ivsrealtime.model.EventName {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.EventName =
      software.amazon.awssdk.services.ivsrealtime.model.EventName.SUBSCRIBE_ERROR
  }
  case object JOIN_ERROR extends zio.aws.ivsrealtime.model.EventName {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.EventName =
      software.amazon.awssdk.services.ivsrealtime.model.EventName.JOIN_ERROR
  }
}
