package zio.aws.ivsrealtime.model
import zio.aws.ivsrealtime.model.primitives.{
  StageArn,
  DisconnectParticipantReason,
  ParticipantTokenId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DisconnectParticipantRequest(
    participantId: ParticipantTokenId,
    reason: Optional[DisconnectParticipantReason] = Optional.Absent,
    stageArn: StageArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.DisconnectParticipantRequest = {
    import DisconnectParticipantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.DisconnectParticipantRequest
      .builder()
      .participantId(ParticipantTokenId.unwrap(participantId): java.lang.String)
      .optionallyWith(
        reason.map(value =>
          DisconnectParticipantReason.unwrap(value): java.lang.String
        )
      )(_.reason)
      .stageArn(StageArn.unwrap(stageArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ivsrealtime.model.DisconnectParticipantRequest.ReadOnly =
    zio.aws.ivsrealtime.model.DisconnectParticipantRequest.wrap(buildAwsValue())
}
object DisconnectParticipantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.DisconnectParticipantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.DisconnectParticipantRequest =
      zio.aws.ivsrealtime.model.DisconnectParticipantRequest(
        participantId,
        reason.map(value => value),
        stageArn
      )
    def participantId: ParticipantTokenId
    def reason: Optional[DisconnectParticipantReason]
    def stageArn: StageArn
    def getParticipantId: ZIO[Any, Nothing, ParticipantTokenId] =
      ZIO.succeed(participantId)
    def getReason: ZIO[Any, AwsError, DisconnectParticipantReason] =
      AwsError.unwrapOptionField("reason", reason)
    def getStageArn: ZIO[Any, Nothing, StageArn] = ZIO.succeed(stageArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.DisconnectParticipantRequest
  ) extends zio.aws.ivsrealtime.model.DisconnectParticipantRequest.ReadOnly {
    override val participantId: ParticipantTokenId =
      zio.aws.ivsrealtime.model.primitives
        .ParticipantTokenId(impl.participantId())
    override val reason: Optional[DisconnectParticipantReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reason())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives
            .DisconnectParticipantReason(value)
        )
    override val stageArn: StageArn =
      zio.aws.ivsrealtime.model.primitives.StageArn(impl.stageArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.DisconnectParticipantRequest
  ): zio.aws.ivsrealtime.model.DisconnectParticipantRequest.ReadOnly =
    new Wrapper(impl)
}
