package zio.aws.ivsrealtime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStageResponse(
    participantTokens: Optional[
      Iterable[zio.aws.ivsrealtime.model.ParticipantToken]
    ] = Optional.Absent,
    stage: Optional[zio.aws.ivsrealtime.model.Stage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.CreateStageResponse = {
    import CreateStageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.CreateStageResponse
      .builder()
      .optionallyWith(
        participantTokens.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.participantTokens)
      .optionallyWith(stage.map(value => value.buildAwsValue()))(_.stage)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.CreateStageResponse.ReadOnly =
    zio.aws.ivsrealtime.model.CreateStageResponse.wrap(buildAwsValue())
}
object CreateStageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.CreateStageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.CreateStageResponse =
      zio.aws.ivsrealtime.model.CreateStageResponse(
        participantTokens.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stage.map(value => value.asEditable)
      )
    def participantTokens
        : Optional[List[zio.aws.ivsrealtime.model.ParticipantToken.ReadOnly]]
    def stage: Optional[zio.aws.ivsrealtime.model.Stage.ReadOnly]
    def getParticipantTokens: ZIO[Any, AwsError, List[
      zio.aws.ivsrealtime.model.ParticipantToken.ReadOnly
    ]] = AwsError.unwrapOptionField("participantTokens", participantTokens)
    def getStage: ZIO[Any, AwsError, zio.aws.ivsrealtime.model.Stage.ReadOnly] =
      AwsError.unwrapOptionField("stage", stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.CreateStageResponse
  ) extends zio.aws.ivsrealtime.model.CreateStageResponse.ReadOnly {
    override val participantTokens
        : Optional[List[zio.aws.ivsrealtime.model.ParticipantToken.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participantTokens())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ivsrealtime.model.ParticipantToken.wrap(item)
          }.toList
        )
    override val stage: Optional[zio.aws.ivsrealtime.model.Stage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stage())
        .map(value => zio.aws.ivsrealtime.model.Stage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.CreateStageResponse
  ): zio.aws.ivsrealtime.model.CreateStageResponse.ReadOnly = new Wrapper(impl)
}
