package zio.aws.ivsrealtime.model
import zio.aws.ivsrealtime.model.primitives.{StageName, StageArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStageRequest(
    arn: StageArn,
    name: Optional[StageName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.UpdateStageRequest = {
    import UpdateStageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.UpdateStageRequest
      .builder()
      .arn(StageArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        name.map(value => StageName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.UpdateStageRequest.ReadOnly =
    zio.aws.ivsrealtime.model.UpdateStageRequest.wrap(buildAwsValue())
}
object UpdateStageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.UpdateStageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.UpdateStageRequest =
      zio.aws.ivsrealtime.model
        .UpdateStageRequest(arn, name.map(value => value))
    def arn: StageArn
    def name: Optional[StageName]
    def getArn: ZIO[Any, Nothing, StageArn] = ZIO.succeed(arn)
    def getName: ZIO[Any, AwsError, StageName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.UpdateStageRequest
  ) extends zio.aws.ivsrealtime.model.UpdateStageRequest.ReadOnly {
    override val arn: StageArn =
      zio.aws.ivsrealtime.model.primitives.StageArn(impl.arn())
    override val name: Optional[StageName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ivsrealtime.model.primitives.StageName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.UpdateStageRequest
  ): zio.aws.ivsrealtime.model.UpdateStageRequest.ReadOnly = new Wrapper(impl)
}
