package zio.aws.ivsrealtime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivsrealtime.model.primitives.{
  Time,
  UserId,
  ParticipantClientAttribute,
  ParticipantId,
  Published
}
import scala.jdk.CollectionConverters._
final case class Participant(
    attributes: Optional[Map[String, String]] = Optional.Absent,
    browserName: Optional[ParticipantClientAttribute] = Optional.Absent,
    browserVersion: Optional[ParticipantClientAttribute] = Optional.Absent,
    firstJoinTime: Optional[Time] = Optional.Absent,
    ispName: Optional[ParticipantClientAttribute] = Optional.Absent,
    osName: Optional[ParticipantClientAttribute] = Optional.Absent,
    osVersion: Optional[ParticipantClientAttribute] = Optional.Absent,
    participantId: Optional[ParticipantId] = Optional.Absent,
    published: Optional[Published] = Optional.Absent,
    sdkVersion: Optional[ParticipantClientAttribute] = Optional.Absent,
    state: Optional[zio.aws.ivsrealtime.model.ParticipantState] =
      Optional.Absent,
    userId: Optional[UserId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.Participant = {
    import Participant.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.Participant
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        browserName.map(value =>
          ParticipantClientAttribute.unwrap(value): java.lang.String
        )
      )(_.browserName)
      .optionallyWith(
        browserVersion.map(value =>
          ParticipantClientAttribute.unwrap(value): java.lang.String
        )
      )(_.browserVersion)
      .optionallyWith(firstJoinTime.map(value => Time.unwrap(value): Instant))(
        _.firstJoinTime
      )
      .optionallyWith(
        ispName.map(value =>
          ParticipantClientAttribute.unwrap(value): java.lang.String
        )
      )(_.ispName)
      .optionallyWith(
        osName.map(value =>
          ParticipantClientAttribute.unwrap(value): java.lang.String
        )
      )(_.osName)
      .optionallyWith(
        osVersion.map(value =>
          ParticipantClientAttribute.unwrap(value): java.lang.String
        )
      )(_.osVersion)
      .optionallyWith(
        participantId.map(value =>
          ParticipantId.unwrap(value): java.lang.String
        )
      )(_.participantId)
      .optionallyWith(
        published.map(value => Published.unwrap(value): java.lang.Boolean)
      )(_.published)
      .optionallyWith(
        sdkVersion.map(value =>
          ParticipantClientAttribute.unwrap(value): java.lang.String
        )
      )(_.sdkVersion)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.Participant.ReadOnly =
    zio.aws.ivsrealtime.model.Participant.wrap(buildAwsValue())
}
object Participant {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.Participant
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.Participant =
      zio.aws.ivsrealtime.model.Participant(
        attributes.map(value => value),
        browserName.map(value => value),
        browserVersion.map(value => value),
        firstJoinTime.map(value => value),
        ispName.map(value => value),
        osName.map(value => value),
        osVersion.map(value => value),
        participantId.map(value => value),
        published.map(value => value),
        sdkVersion.map(value => value),
        state.map(value => value),
        userId.map(value => value)
      )
    def attributes: Optional[Map[String, String]]
    def browserName: Optional[ParticipantClientAttribute]
    def browserVersion: Optional[ParticipantClientAttribute]
    def firstJoinTime: Optional[Time]
    def ispName: Optional[ParticipantClientAttribute]
    def osName: Optional[ParticipantClientAttribute]
    def osVersion: Optional[ParticipantClientAttribute]
    def participantId: Optional[ParticipantId]
    def published: Optional[Published]
    def sdkVersion: Optional[ParticipantClientAttribute]
    def state: Optional[zio.aws.ivsrealtime.model.ParticipantState]
    def userId: Optional[UserId]
    def getAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getBrowserName: ZIO[Any, AwsError, ParticipantClientAttribute] =
      AwsError.unwrapOptionField("browserName", browserName)
    def getBrowserVersion: ZIO[Any, AwsError, ParticipantClientAttribute] =
      AwsError.unwrapOptionField("browserVersion", browserVersion)
    def getFirstJoinTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("firstJoinTime", firstJoinTime)
    def getIspName: ZIO[Any, AwsError, ParticipantClientAttribute] =
      AwsError.unwrapOptionField("ispName", ispName)
    def getOsName: ZIO[Any, AwsError, ParticipantClientAttribute] =
      AwsError.unwrapOptionField("osName", osName)
    def getOsVersion: ZIO[Any, AwsError, ParticipantClientAttribute] =
      AwsError.unwrapOptionField("osVersion", osVersion)
    def getParticipantId: ZIO[Any, AwsError, ParticipantId] =
      AwsError.unwrapOptionField("participantId", participantId)
    def getPublished: ZIO[Any, AwsError, Published] =
      AwsError.unwrapOptionField("published", published)
    def getSdkVersion: ZIO[Any, AwsError, ParticipantClientAttribute] =
      AwsError.unwrapOptionField("sdkVersion", sdkVersion)
    def getState
        : ZIO[Any, AwsError, zio.aws.ivsrealtime.model.ParticipantState] =
      AwsError.unwrapOptionField("state", state)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.Participant
  ) extends zio.aws.ivsrealtime.model.Participant.ReadOnly {
    override val attributes: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val browserName: Optional[ParticipantClientAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.browserName())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives.ParticipantClientAttribute(value)
        )
    override val browserVersion: Optional[ParticipantClientAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.browserVersion())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives.ParticipantClientAttribute(value)
        )
    override val firstJoinTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.firstJoinTime())
      .map(value => zio.aws.ivsrealtime.model.primitives.Time(value))
    override val ispName: Optional[ParticipantClientAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ispName())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives.ParticipantClientAttribute(value)
        )
    override val osName: Optional[ParticipantClientAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.osName())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives.ParticipantClientAttribute(value)
        )
    override val osVersion: Optional[ParticipantClientAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.osVersion())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives.ParticipantClientAttribute(value)
        )
    override val participantId: Optional[ParticipantId] = zio.aws.core.internal
      .optionalFromNullable(impl.participantId())
      .map(value => zio.aws.ivsrealtime.model.primitives.ParticipantId(value))
    override val published: Optional[Published] = zio.aws.core.internal
      .optionalFromNullable(impl.published())
      .map(value => zio.aws.ivsrealtime.model.primitives.Published(value))
    override val sdkVersion: Optional[ParticipantClientAttribute] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sdkVersion())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives.ParticipantClientAttribute(value)
        )
    override val state: Optional[zio.aws.ivsrealtime.model.ParticipantState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ivsrealtime.model.ParticipantState.wrap(value))
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.ivsrealtime.model.primitives.UserId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.Participant
  ): zio.aws.ivsrealtime.model.Participant.ReadOnly = new Wrapper(impl)
}
