package zio.aws.ivsrealtime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivsrealtime.model.primitives.{ParticipantId, Time}
import scala.jdk.CollectionConverters._
final case class Event(
    errorCode: Optional[zio.aws.ivsrealtime.model.EventErrorCode] =
      Optional.Absent,
    eventTime: Optional[Time] = Optional.Absent,
    name: Optional[zio.aws.ivsrealtime.model.EventName] = Optional.Absent,
    participantId: Optional[ParticipantId] = Optional.Absent,
    remoteParticipantId: Optional[ParticipantId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.Event = {
    import Event.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.Event
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(eventTime.map(value => Time.unwrap(value): Instant))(
        _.eventTime
      )
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        participantId.map(value =>
          ParticipantId.unwrap(value): java.lang.String
        )
      )(_.participantId)
      .optionallyWith(
        remoteParticipantId.map(value =>
          ParticipantId.unwrap(value): java.lang.String
        )
      )(_.remoteParticipantId)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.Event.ReadOnly =
    zio.aws.ivsrealtime.model.Event.wrap(buildAwsValue())
}
object Event {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ivsrealtime.model.Event] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.Event =
      zio.aws.ivsrealtime.model.Event(
        errorCode.map(value => value),
        eventTime.map(value => value),
        name.map(value => value),
        participantId.map(value => value),
        remoteParticipantId.map(value => value)
      )
    def errorCode: Optional[zio.aws.ivsrealtime.model.EventErrorCode]
    def eventTime: Optional[Time]
    def name: Optional[zio.aws.ivsrealtime.model.EventName]
    def participantId: Optional[ParticipantId]
    def remoteParticipantId: Optional[ParticipantId]
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.ivsrealtime.model.EventErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getEventTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("eventTime", eventTime)
    def getName: ZIO[Any, AwsError, zio.aws.ivsrealtime.model.EventName] =
      AwsError.unwrapOptionField("name", name)
    def getParticipantId: ZIO[Any, AwsError, ParticipantId] =
      AwsError.unwrapOptionField("participantId", participantId)
    def getRemoteParticipantId: ZIO[Any, AwsError, ParticipantId] =
      AwsError.unwrapOptionField("remoteParticipantId", remoteParticipantId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.Event
  ) extends zio.aws.ivsrealtime.model.Event.ReadOnly {
    override val errorCode: Optional[zio.aws.ivsrealtime.model.EventErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.ivsrealtime.model.EventErrorCode.wrap(value))
    override val eventTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.eventTime())
      .map(value => zio.aws.ivsrealtime.model.primitives.Time(value))
    override val name: Optional[zio.aws.ivsrealtime.model.EventName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.ivsrealtime.model.EventName.wrap(value))
    override val participantId: Optional[ParticipantId] = zio.aws.core.internal
      .optionalFromNullable(impl.participantId())
      .map(value => zio.aws.ivsrealtime.model.primitives.ParticipantId(value))
    override val remoteParticipantId: Optional[ParticipantId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.remoteParticipantId())
        .map(value => zio.aws.ivsrealtime.model.primitives.ParticipantId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.Event
  ): zio.aws.ivsrealtime.model.Event.ReadOnly = new Wrapper(impl)
}
