package zio.aws.ivsrealtime
import zio.prelude.Subtype
import zio.aws.ivsrealtime.model.primitives.{TagValue, TagKey}
import java.time.Instant
import zio.aws.ivsrealtime.model.primitives.MaxStageResults.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object DisconnectParticipantReason extends Subtype[String]
    type DisconnectParticipantReason =
      zio.aws.ivsrealtime.model.primitives.DisconnectParticipantReason.Type
    object MaxParticipantEventResults extends Subtype[Int]
    type MaxParticipantEventResults =
      zio.aws.ivsrealtime.model.primitives.MaxParticipantEventResults.Type
    object MaxParticipantResults extends Subtype[Int]
    type MaxParticipantResults =
      zio.aws.ivsrealtime.model.primitives.MaxParticipantResults.Type
    object MaxStageResults extends Subtype[Int]
    type MaxStageResults =
      zio.aws.ivsrealtime.model.primitives.MaxStageResults.Type
    object MaxStageSessionResults extends Subtype[Int]
    type MaxStageSessionResults =
      zio.aws.ivsrealtime.model.primitives.MaxStageSessionResults.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.ivsrealtime.model.primitives.PaginationToken.Type
    object ParticipantClientAttribute extends Subtype[String]
    type ParticipantClientAttribute =
      zio.aws.ivsrealtime.model.primitives.ParticipantClientAttribute.Type
    object ParticipantId extends Subtype[String]
    type ParticipantId = zio.aws.ivsrealtime.model.primitives.ParticipantId.Type
    object ParticipantTokenDurationMinutes extends Subtype[Int]
    type ParticipantTokenDurationMinutes =
      zio.aws.ivsrealtime.model.primitives.ParticipantTokenDurationMinutes.Type
    object ParticipantTokenExpirationTime extends Subtype[Instant]
    type ParticipantTokenExpirationTime =
      zio.aws.ivsrealtime.model.primitives.ParticipantTokenExpirationTime.Type
    object ParticipantTokenId extends Subtype[String]
    type ParticipantTokenId =
      zio.aws.ivsrealtime.model.primitives.ParticipantTokenId.Type
    object ParticipantTokenString extends Subtype[String]
    type ParticipantTokenString =
      zio.aws.ivsrealtime.model.primitives.ParticipantTokenString.Type
    object ParticipantTokenUserId extends Subtype[String]
    type ParticipantTokenUserId =
      zio.aws.ivsrealtime.model.primitives.ParticipantTokenUserId.Type
    object Published extends Subtype[Boolean]
    type Published = zio.aws.ivsrealtime.model.primitives.Published.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.ivsrealtime.model.primitives.ResourceArn.Type
    object StageArn extends Subtype[String]
    type StageArn = zio.aws.ivsrealtime.model.primitives.StageArn.Type
    object StageName extends Subtype[String]
    type StageName = zio.aws.ivsrealtime.model.primitives.StageName.Type
    object StageSessionId extends Subtype[String]
    type StageSessionId =
      zio.aws.ivsrealtime.model.primitives.StageSessionId.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.ivsrealtime.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.ivsrealtime.model.primitives.TagValue.Type
    object Time extends Subtype[Instant]
    type Time = zio.aws.ivsrealtime.model.primitives.Time.Type
    object UserId extends Subtype[String]
    type UserId = zio.aws.ivsrealtime.model.primitives.UserId.Type
  }
  type EventList = List[zio.aws.ivsrealtime.model.Event]
  type ParticipantAttributes = Map[String, String]
  type ParticipantList = List[zio.aws.ivsrealtime.model.ParticipantSummary]
  type ParticipantTokenAttributes = Map[String, String]
  type ParticipantTokenCapabilities =
    List[zio.aws.ivsrealtime.model.ParticipantTokenCapability]
  type ParticipantTokenConfigurations =
    List[zio.aws.ivsrealtime.model.ParticipantTokenConfiguration]
  type ParticipantTokenList = List[zio.aws.ivsrealtime.model.ParticipantToken]
  type StageSessionList = List[zio.aws.ivsrealtime.model.StageSessionSummary]
  type StageSummaryList = List[zio.aws.ivsrealtime.model.StageSummary]
  type TagKeyList = List[TagKey]
  type Tags = Map[TagKey, TagValue]
}
