package zio.aws.ivsrealtime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateStageResponse(
    stage: Optional[zio.aws.ivsrealtime.model.Stage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.UpdateStageResponse = {
    import UpdateStageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.UpdateStageResponse
      .builder()
      .optionallyWith(stage.map(value => value.buildAwsValue()))(_.stage)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.UpdateStageResponse.ReadOnly =
    zio.aws.ivsrealtime.model.UpdateStageResponse.wrap(buildAwsValue())
}
object UpdateStageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.UpdateStageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.UpdateStageResponse =
      zio.aws.ivsrealtime.model
        .UpdateStageResponse(stage.map(value => value.asEditable))
    def stage: Optional[zio.aws.ivsrealtime.model.Stage.ReadOnly]
    def getStage: ZIO[Any, AwsError, zio.aws.ivsrealtime.model.Stage.ReadOnly] =
      AwsError.unwrapOptionField("stage", stage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.UpdateStageResponse
  ) extends zio.aws.ivsrealtime.model.UpdateStageResponse.ReadOnly {
    override val stage: Optional[zio.aws.ivsrealtime.model.Stage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stage())
        .map(value => zio.aws.ivsrealtime.model.Stage.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.UpdateStageResponse
  ): zio.aws.ivsrealtime.model.UpdateStageResponse.ReadOnly = new Wrapper(impl)
}
