package zio.aws.ivsrealtime.model
import scala.jdk.CollectionConverters._
sealed trait ParticipantState {
  def unwrap: software.amazon.awssdk.services.ivsrealtime.model.ParticipantState
}
object ParticipantState {
  def wrap(
      value: software.amazon.awssdk.services.ivsrealtime.model.ParticipantState
  ): zio.aws.ivsrealtime.model.ParticipantState = value match {
    case software.amazon.awssdk.services.ivsrealtime.model.ParticipantState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivsrealtime.model.ParticipantState.CONNECTED =>
      val r = CONNECTED
      r
    case software.amazon.awssdk.services.ivsrealtime.model.ParticipantState.DISCONNECTED =>
      val r = DISCONNECTED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ivsrealtime.model.ParticipantState {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.ParticipantState =
      software.amazon.awssdk.services.ivsrealtime.model.ParticipantState.UNKNOWN_TO_SDK_VERSION
  }
  case object CONNECTED extends zio.aws.ivsrealtime.model.ParticipantState {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.ParticipantState =
      software.amazon.awssdk.services.ivsrealtime.model.ParticipantState.CONNECTED
  }
  case object DISCONNECTED extends zio.aws.ivsrealtime.model.ParticipantState {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.ParticipantState =
      software.amazon.awssdk.services.ivsrealtime.model.ParticipantState.DISCONNECTED
  }
}
