package zio.aws.ivsrealtime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivsrealtime.model.primitives.{
  MaxParticipantEventResults,
  StageSessionId,
  StageArn,
  PaginationToken,
  ParticipantId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListParticipantEventsRequest(
    maxResults: Optional[MaxParticipantEventResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    participantId: ParticipantId,
    sessionId: StageSessionId,
    stageArn: StageArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsRequest = {
    import ListParticipantEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          MaxParticipantEventResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .participantId(ParticipantId.unwrap(participantId): java.lang.String)
      .sessionId(StageSessionId.unwrap(sessionId): java.lang.String)
      .stageArn(StageArn.unwrap(stageArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ivsrealtime.model.ListParticipantEventsRequest.ReadOnly =
    zio.aws.ivsrealtime.model.ListParticipantEventsRequest.wrap(buildAwsValue())
}
object ListParticipantEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.ListParticipantEventsRequest =
      zio.aws.ivsrealtime.model.ListParticipantEventsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        participantId,
        sessionId,
        stageArn
      )
    def maxResults: Optional[MaxParticipantEventResults]
    def nextToken: Optional[PaginationToken]
    def participantId: ParticipantId
    def sessionId: StageSessionId
    def stageArn: StageArn
    def getMaxResults: ZIO[Any, AwsError, MaxParticipantEventResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getParticipantId: ZIO[Any, Nothing, ParticipantId] =
      ZIO.succeed(participantId)
    def getSessionId: ZIO[Any, Nothing, StageSessionId] = ZIO.succeed(sessionId)
    def getStageArn: ZIO[Any, Nothing, StageArn] = ZIO.succeed(stageArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsRequest
  ) extends zio.aws.ivsrealtime.model.ListParticipantEventsRequest.ReadOnly {
    override val maxResults: Optional[MaxParticipantEventResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives.MaxParticipantEventResults(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivsrealtime.model.primitives.PaginationToken(value))
    override val participantId: ParticipantId =
      zio.aws.ivsrealtime.model.primitives.ParticipantId(impl.participantId())
    override val sessionId: StageSessionId =
      zio.aws.ivsrealtime.model.primitives.StageSessionId(impl.sessionId())
    override val stageArn: StageArn =
      zio.aws.ivsrealtime.model.primitives.StageArn(impl.stageArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsRequest
  ): zio.aws.ivsrealtime.model.ListParticipantEventsRequest.ReadOnly =
    new Wrapper(impl)
}
