package zio.aws.ivsrealtime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetStageSessionResponse(
    stageSession: Optional[zio.aws.ivsrealtime.model.StageSession] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.GetStageSessionResponse = {
    import GetStageSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.GetStageSessionResponse
      .builder()
      .optionallyWith(stageSession.map(value => value.buildAwsValue()))(
        _.stageSession
      )
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.GetStageSessionResponse.ReadOnly =
    zio.aws.ivsrealtime.model.GetStageSessionResponse.wrap(buildAwsValue())
}
object GetStageSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.GetStageSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.GetStageSessionResponse =
      zio.aws.ivsrealtime.model
        .GetStageSessionResponse(stageSession.map(value => value.asEditable))
    def stageSession: Optional[zio.aws.ivsrealtime.model.StageSession.ReadOnly]
    def getStageSession
        : ZIO[Any, AwsError, zio.aws.ivsrealtime.model.StageSession.ReadOnly] =
      AwsError.unwrapOptionField("stageSession", stageSession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.GetStageSessionResponse
  ) extends zio.aws.ivsrealtime.model.GetStageSessionResponse.ReadOnly {
    override val stageSession
        : Optional[zio.aws.ivsrealtime.model.StageSession.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stageSession())
        .map(value => zio.aws.ivsrealtime.model.StageSession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.GetStageSessionResponse
  ): zio.aws.ivsrealtime.model.GetStageSessionResponse.ReadOnly = new Wrapper(
    impl
  )
}
