package zio.aws.ivsrealtime.model
import scala.jdk.CollectionConverters._
sealed trait EventErrorCode {
  def unwrap: software.amazon.awssdk.services.ivsrealtime.model.EventErrorCode
}
object EventErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.ivsrealtime.model.EventErrorCode
  ): zio.aws.ivsrealtime.model.EventErrorCode = value match {
    case software.amazon.awssdk.services.ivsrealtime.model.EventErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivsrealtime.model.EventErrorCode.INSUFFICIENT_CAPABILITIES =>
      val r = INSUFFICIENT_CAPABILITIES
      r
    case software.amazon.awssdk.services.ivsrealtime.model.EventErrorCode.QUOTA_EXCEEDED =>
      val r = QUOTA_EXCEEDED
      r
    case software.amazon.awssdk.services.ivsrealtime.model.EventErrorCode.PUBLISHER_NOT_FOUND =>
      val r = PUBLISHER_NOT_FOUND
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ivsrealtime.model.EventErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.EventErrorCode =
      software.amazon.awssdk.services.ivsrealtime.model.EventErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INSUFFICIENT_CAPABILITIES
      extends zio.aws.ivsrealtime.model.EventErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.EventErrorCode =
      software.amazon.awssdk.services.ivsrealtime.model.EventErrorCode.INSUFFICIENT_CAPABILITIES
  }
  case object QUOTA_EXCEEDED extends zio.aws.ivsrealtime.model.EventErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.EventErrorCode =
      software.amazon.awssdk.services.ivsrealtime.model.EventErrorCode.QUOTA_EXCEEDED
  }
  case object PUBLISHER_NOT_FOUND
      extends zio.aws.ivsrealtime.model.EventErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.EventErrorCode =
      software.amazon.awssdk.services.ivsrealtime.model.EventErrorCode.PUBLISHER_NOT_FOUND
  }
}
