package zio.aws.ivsrealtime.model
import zio.aws.ivsrealtime.model.primitives.{TagValue, TagKey, StageName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateStageRequest(
    name: Optional[StageName] = Optional.Absent,
    participantTokenConfigurations: Optional[
      Iterable[zio.aws.ivsrealtime.model.ParticipantTokenConfiguration]
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.CreateStageRequest = {
    import CreateStageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.CreateStageRequest
      .builder()
      .optionallyWith(
        name.map(value => StageName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        participantTokenConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.participantTokenConfigurations)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.CreateStageRequest.ReadOnly =
    zio.aws.ivsrealtime.model.CreateStageRequest.wrap(buildAwsValue())
}
object CreateStageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.CreateStageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.CreateStageRequest =
      zio.aws.ivsrealtime.model.CreateStageRequest(
        name.map(value => value),
        participantTokenConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value => value)
      )
    def name: Optional[StageName]
    def participantTokenConfigurations: Optional[
      List[zio.aws.ivsrealtime.model.ParticipantTokenConfiguration.ReadOnly]
    ]
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, AwsError, StageName] =
      AwsError.unwrapOptionField("name", name)
    def getParticipantTokenConfigurations: ZIO[Any, AwsError, List[
      zio.aws.ivsrealtime.model.ParticipantTokenConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "participantTokenConfigurations",
      participantTokenConfigurations
    )
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.CreateStageRequest
  ) extends zio.aws.ivsrealtime.model.CreateStageRequest.ReadOnly {
    override val name: Optional[StageName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ivsrealtime.model.primitives.StageName(value))
    override val participantTokenConfigurations: Optional[
      List[zio.aws.ivsrealtime.model.ParticipantTokenConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.participantTokenConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ivsrealtime.model.ParticipantTokenConfiguration.wrap(item)
        }.toList
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivsrealtime.model.primitives.TagKey(
              key
            ) -> zio.aws.ivsrealtime.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.CreateStageRequest
  ): zio.aws.ivsrealtime.model.CreateStageRequest.ReadOnly = new Wrapper(impl)
}
