package zio.aws.ivsrealtime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateParticipantTokenResponse(
    participantToken: Optional[zio.aws.ivsrealtime.model.ParticipantToken] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.CreateParticipantTokenResponse = {
    import CreateParticipantTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.CreateParticipantTokenResponse
      .builder()
      .optionallyWith(participantToken.map(value => value.buildAwsValue()))(
        _.participantToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ivsrealtime.model.CreateParticipantTokenResponse.ReadOnly =
    zio.aws.ivsrealtime.model.CreateParticipantTokenResponse
      .wrap(buildAwsValue())
}
object CreateParticipantTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.CreateParticipantTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.CreateParticipantTokenResponse =
      zio.aws.ivsrealtime.model.CreateParticipantTokenResponse(
        participantToken.map(value => value.asEditable)
      )
    def participantToken
        : Optional[zio.aws.ivsrealtime.model.ParticipantToken.ReadOnly]
    def getParticipantToken: ZIO[
      Any,
      AwsError,
      zio.aws.ivsrealtime.model.ParticipantToken.ReadOnly
    ] = AwsError.unwrapOptionField("participantToken", participantToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.CreateParticipantTokenResponse
  ) extends zio.aws.ivsrealtime.model.CreateParticipantTokenResponse.ReadOnly {
    override val participantToken
        : Optional[zio.aws.ivsrealtime.model.ParticipantToken.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participantToken())
        .map(value => zio.aws.ivsrealtime.model.ParticipantToken.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.CreateParticipantTokenResponse
  ): zio.aws.ivsrealtime.model.CreateParticipantTokenResponse.ReadOnly =
    new Wrapper(impl)
}
