package zio.aws.ivsrealtime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivsrealtime.model.primitives.{
  ParticipantTokenUserId,
  StageArn,
  ParticipantTokenDurationMinutes
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateParticipantTokenRequest(
    attributes: Optional[Map[String, String]] = Optional.Absent,
    capabilities: Optional[
      Iterable[zio.aws.ivsrealtime.model.ParticipantTokenCapability]
    ] = Optional.Absent,
    duration: Optional[ParticipantTokenDurationMinutes] = Optional.Absent,
    stageArn: StageArn,
    userId: Optional[ParticipantTokenUserId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.CreateParticipantTokenRequest = {
    import CreateParticipantTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.CreateParticipantTokenRequest
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        capabilities.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.capabilitiesWithStrings)
      .optionallyWith(
        duration.map(value =>
          ParticipantTokenDurationMinutes.unwrap(value): Integer
        )
      )(_.duration)
      .stageArn(StageArn.unwrap(stageArn): java.lang.String)
      .optionallyWith(
        userId.map(value =>
          ParticipantTokenUserId.unwrap(value): java.lang.String
        )
      )(_.userId)
      .build()
  }
  def asReadOnly
      : zio.aws.ivsrealtime.model.CreateParticipantTokenRequest.ReadOnly =
    zio.aws.ivsrealtime.model.CreateParticipantTokenRequest
      .wrap(buildAwsValue())
}
object CreateParticipantTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.CreateParticipantTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.CreateParticipantTokenRequest =
      zio.aws.ivsrealtime.model.CreateParticipantTokenRequest(
        attributes.map(value => value),
        capabilities.map(value => value),
        duration.map(value => value),
        stageArn,
        userId.map(value => value)
      )
    def attributes: Optional[Map[String, String]]
    def capabilities
        : Optional[List[zio.aws.ivsrealtime.model.ParticipantTokenCapability]]
    def duration: Optional[ParticipantTokenDurationMinutes]
    def stageArn: StageArn
    def userId: Optional[ParticipantTokenUserId]
    def getAttributes: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getCapabilities: ZIO[Any, AwsError, List[
      zio.aws.ivsrealtime.model.ParticipantTokenCapability
    ]] = AwsError.unwrapOptionField("capabilities", capabilities)
    def getDuration: ZIO[Any, AwsError, ParticipantTokenDurationMinutes] =
      AwsError.unwrapOptionField("duration", duration)
    def getStageArn: ZIO[Any, Nothing, StageArn] = ZIO.succeed(stageArn)
    def getUserId: ZIO[Any, AwsError, ParticipantTokenUserId] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.CreateParticipantTokenRequest
  ) extends zio.aws.ivsrealtime.model.CreateParticipantTokenRequest.ReadOnly {
    override val attributes: Optional[Map[String, String]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> (value: String)
            })
            .toMap
        )
    override val capabilities
        : Optional[List[zio.aws.ivsrealtime.model.ParticipantTokenCapability]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capabilities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ivsrealtime.model.ParticipantTokenCapability.wrap(item)
          }.toList
        )
    override val duration: Optional[ParticipantTokenDurationMinutes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.duration())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives
            .ParticipantTokenDurationMinutes(value)
        )
    override val stageArn: StageArn =
      zio.aws.ivsrealtime.model.primitives.StageArn(impl.stageArn())
    override val userId: Optional[ParticipantTokenUserId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userId())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives.ParticipantTokenUserId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.CreateParticipantTokenRequest
  ): zio.aws.ivsrealtime.model.CreateParticipantTokenRequest.ReadOnly =
    new Wrapper(impl)
}
