package zio.aws.ivsrealtime
import zio.aws.ivsrealtime.model.ListParticipantsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeAsyncClient
import zio.aws.ivsrealtime.model.{
  ListParticipantEventsRequest,
  ListParticipantsRequest,
  CreateStageRequest,
  DeleteStageRequest,
  CreateParticipantTokenRequest,
  ListTagsForResourceRequest,
  ListStageSessionsRequest,
  GetParticipantRequest,
  GetStageSessionRequest,
  DisconnectParticipantRequest,
  UntagResourceRequest,
  GetStageRequest,
  UpdateStageRequest,
  ListStagesRequest,
  TagResourceRequest
}
import zio.{IO, ZEnvironment, URLayer}
object IvsRealTimeMock extends Mock[IvsRealTime] {
  object UpdateStage
      extends Effect[
        UpdateStageRequest,
        AwsError,
        zio.aws.ivsrealtime.model.UpdateStageResponse.ReadOnly
      ]
  object DisconnectParticipant
      extends Effect[
        DisconnectParticipantRequest,
        AwsError,
        zio.aws.ivsrealtime.model.DisconnectParticipantResponse.ReadOnly
      ]
  object GetStage
      extends Effect[
        GetStageRequest,
        AwsError,
        zio.aws.ivsrealtime.model.GetStageResponse.ReadOnly
      ]
  object ListStages
      extends Effect[
        ListStagesRequest,
        AwsError,
        zio.aws.ivsrealtime.model.ListStagesResponse.ReadOnly
      ]
  object ListParticipants
      extends Effect[ListParticipantsRequest, AwsError, ReadOnly]
  object DeleteStage
      extends Effect[
        DeleteStageRequest,
        AwsError,
        zio.aws.ivsrealtime.model.DeleteStageResponse.ReadOnly
      ]
  object CreateParticipantToken
      extends Effect[
        CreateParticipantTokenRequest,
        AwsError,
        zio.aws.ivsrealtime.model.CreateParticipantTokenResponse.ReadOnly
      ]
  object ListStageSessions
      extends Effect[
        ListStageSessionsRequest,
        AwsError,
        zio.aws.ivsrealtime.model.ListStageSessionsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.ivsrealtime.model.UntagResourceResponse.ReadOnly
      ]
  object GetParticipant
      extends Effect[
        GetParticipantRequest,
        AwsError,
        zio.aws.ivsrealtime.model.GetParticipantResponse.ReadOnly
      ]
  object CreateStage
      extends Effect[
        CreateStageRequest,
        AwsError,
        zio.aws.ivsrealtime.model.CreateStageResponse.ReadOnly
      ]
  object ListParticipantEvents
      extends Effect[
        ListParticipantEventsRequest,
        AwsError,
        zio.aws.ivsrealtime.model.ListParticipantEventsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.ivsrealtime.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.ivsrealtime.model.TagResourceResponse.ReadOnly
      ]
  object GetStageSession
      extends Effect[
        GetStageSessionRequest,
        AwsError,
        zio.aws.ivsrealtime.model.GetStageSessionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, IvsRealTime] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, IvsRealTime] { rts =>
        zio.ZIO.succeed {
          new IvsRealTime {
            val api: IvsRealTimeAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): IvsRealTime = this
            def updateStage(request: UpdateStageRequest): IO[
              AwsError,
              zio.aws.ivsrealtime.model.UpdateStageResponse.ReadOnly
            ] = proxy(UpdateStage, request)
            def disconnectParticipant(
                request: DisconnectParticipantRequest
            ): IO[
              AwsError,
              zio.aws.ivsrealtime.model.DisconnectParticipantResponse.ReadOnly
            ] = proxy(DisconnectParticipant, request)
            def getStage(request: GetStageRequest): IO[
              AwsError,
              zio.aws.ivsrealtime.model.GetStageResponse.ReadOnly
            ] = proxy(GetStage, request)
            def listStages(request: ListStagesRequest): IO[
              AwsError,
              zio.aws.ivsrealtime.model.ListStagesResponse.ReadOnly
            ] = proxy(ListStages, request)
            def listParticipants(
                request: ListParticipantsRequest
            ): IO[AwsError, ReadOnly] = proxy(ListParticipants, request)
            def deleteStage(request: DeleteStageRequest): IO[
              AwsError,
              zio.aws.ivsrealtime.model.DeleteStageResponse.ReadOnly
            ] = proxy(DeleteStage, request)
            def createParticipantToken(
                request: CreateParticipantTokenRequest
            ): IO[
              AwsError,
              zio.aws.ivsrealtime.model.CreateParticipantTokenResponse.ReadOnly
            ] = proxy(CreateParticipantToken, request)
            def listStageSessions(request: ListStageSessionsRequest): IO[
              AwsError,
              zio.aws.ivsrealtime.model.ListStageSessionsResponse.ReadOnly
            ] = proxy(ListStageSessions, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.ivsrealtime.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def getParticipant(request: GetParticipantRequest): IO[
              AwsError,
              zio.aws.ivsrealtime.model.GetParticipantResponse.ReadOnly
            ] = proxy(GetParticipant, request)
            def createStage(request: CreateStageRequest): IO[
              AwsError,
              zio.aws.ivsrealtime.model.CreateStageResponse.ReadOnly
            ] = proxy(CreateStage, request)
            def listParticipantEvents(
                request: ListParticipantEventsRequest
            ): IO[
              AwsError,
              zio.aws.ivsrealtime.model.ListParticipantEventsResponse.ReadOnly
            ] = proxy(ListParticipantEvents, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.ivsrealtime.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.ivsrealtime.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def getStageSession(request: GetStageSessionRequest): IO[
              AwsError,
              zio.aws.ivsrealtime.model.GetStageSessionResponse.ReadOnly
            ] = proxy(GetStageSession, request)
          }
        }
      }
    }
  }
}
