package zio.aws.ivsrealtime
import zio.aws.ivsrealtime.model.ListParticipantsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.ivsrealtime.model.{
  DisconnectParticipantResponse,
  ListParticipantEventsRequest,
  ListParticipantsRequest,
  CreateStageRequest,
  CreateStageResponse,
  DeleteStageRequest,
  GetParticipantResponse,
  CreateParticipantTokenRequest,
  ListStagesResponse,
  UpdateStageResponse,
  CreateParticipantTokenResponse,
  ListTagsForResourceRequest,
  ListStageSessionsRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetParticipantRequest,
  GetStageSessionRequest,
  DisconnectParticipantRequest,
  UntagResourceRequest,
  GetStageRequest,
  UpdateStageRequest,
  ListStageSessionsResponse,
  GetStageResponse,
  ListParticipantEventsResponse,
  ListParticipantsResponse,
  GetStageSessionResponse,
  TagResourceResponse,
  ListStagesRequest,
  TagResourceRequest,
  DeleteStageResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.ivsrealtime.{
  IvsRealTimeAsyncClientBuilder,
  IvsRealTimeAsyncClient
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import scala.jdk.CollectionConverters._
trait IvsRealTime extends AspectSupport[IvsRealTime] {
  val api: IvsRealTimeAsyncClient
  def updateStage(
      request: zio.aws.ivsrealtime.model.UpdateStageRequest
  ): IO[AwsError, zio.aws.ivsrealtime.model.UpdateStageResponse.ReadOnly]
  def disconnectParticipant(
      request: zio.aws.ivsrealtime.model.DisconnectParticipantRequest
  ): IO[
    AwsError,
    zio.aws.ivsrealtime.model.DisconnectParticipantResponse.ReadOnly
  ]
  def getStage(
      request: zio.aws.ivsrealtime.model.GetStageRequest
  ): IO[AwsError, zio.aws.ivsrealtime.model.GetStageResponse.ReadOnly]
  def listStages(
      request: zio.aws.ivsrealtime.model.ListStagesRequest
  ): IO[AwsError, zio.aws.ivsrealtime.model.ListStagesResponse.ReadOnly]
  def listParticipants(
      request: zio.aws.ivsrealtime.model.ListParticipantsRequest
  ): IO[AwsError, ReadOnly]
  def deleteStage(
      request: zio.aws.ivsrealtime.model.DeleteStageRequest
  ): IO[AwsError, zio.aws.ivsrealtime.model.DeleteStageResponse.ReadOnly]
  def createParticipantToken(
      request: zio.aws.ivsrealtime.model.CreateParticipantTokenRequest
  ): IO[
    AwsError,
    zio.aws.ivsrealtime.model.CreateParticipantTokenResponse.ReadOnly
  ]
  def listStageSessions(
      request: zio.aws.ivsrealtime.model.ListStageSessionsRequest
  ): IO[AwsError, zio.aws.ivsrealtime.model.ListStageSessionsResponse.ReadOnly]
  def untagResource(
      request: zio.aws.ivsrealtime.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.ivsrealtime.model.UntagResourceResponse.ReadOnly]
  def getParticipant(
      request: zio.aws.ivsrealtime.model.GetParticipantRequest
  ): IO[AwsError, zio.aws.ivsrealtime.model.GetParticipantResponse.ReadOnly]
  def createStage(
      request: zio.aws.ivsrealtime.model.CreateStageRequest
  ): IO[AwsError, zio.aws.ivsrealtime.model.CreateStageResponse.ReadOnly]
  def listParticipantEvents(
      request: zio.aws.ivsrealtime.model.ListParticipantEventsRequest
  ): IO[
    AwsError,
    zio.aws.ivsrealtime.model.ListParticipantEventsResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.ivsrealtime.model.ListTagsForResourceRequest
  ): IO[
    AwsError,
    zio.aws.ivsrealtime.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: zio.aws.ivsrealtime.model.TagResourceRequest
  ): IO[AwsError, zio.aws.ivsrealtime.model.TagResourceResponse.ReadOnly]
  def getStageSession(
      request: zio.aws.ivsrealtime.model.GetStageSessionRequest
  ): IO[AwsError, zio.aws.ivsrealtime.model.GetStageSessionResponse.ReadOnly]
}
object IvsRealTime {
  val live: ZLayer[AwsConfig, java.lang.Throwable, IvsRealTime] = customized(
    identity
  )
  def customized(
      customization: IvsRealTimeAsyncClientBuilder => IvsRealTimeAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, IvsRealTime] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: IvsRealTimeAsyncClientBuilder => IvsRealTimeAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, IvsRealTime] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = IvsRealTimeAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[IvsRealTimeAsyncClient, IvsRealTimeAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      IvsRealTimeAsyncClient,
      IvsRealTimeAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new IvsRealTimeImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class IvsRealTimeImpl[R](
      override val api: IvsRealTimeAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends IvsRealTime
      with AwsServiceBase[R] {
    override val serviceName: String = "IvsRealTime"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IvsRealTimeImpl[R1] = new IvsRealTimeImpl(api, newAspect, r)
    def updateStage(
        request: zio.aws.ivsrealtime.model.UpdateStageRequest
    ): IO[AwsError, zio.aws.ivsrealtime.model.UpdateStageResponse.ReadOnly] =
      asyncRequestResponse[UpdateStageRequest, UpdateStageResponse](
        "updateStage",
        api.updateStage
      )(request.buildAwsValue())
        .map(zio.aws.ivsrealtime.model.UpdateStageResponse.wrap)
        .provideEnvironment(r)
    def disconnectParticipant(
        request: zio.aws.ivsrealtime.model.DisconnectParticipantRequest
    ): IO[
      AwsError,
      zio.aws.ivsrealtime.model.DisconnectParticipantResponse.ReadOnly
    ] = asyncRequestResponse[
      DisconnectParticipantRequest,
      DisconnectParticipantResponse
    ]("disconnectParticipant", api.disconnectParticipant)(
      request.buildAwsValue()
    ).map(zio.aws.ivsrealtime.model.DisconnectParticipantResponse.wrap)
      .provideEnvironment(r)
    def getStage(
        request: zio.aws.ivsrealtime.model.GetStageRequest
    ): IO[AwsError, zio.aws.ivsrealtime.model.GetStageResponse.ReadOnly] =
      asyncRequestResponse[GetStageRequest, GetStageResponse](
        "getStage",
        api.getStage
      )(request.buildAwsValue())
        .map(zio.aws.ivsrealtime.model.GetStageResponse.wrap)
        .provideEnvironment(r)
    def listStages(
        request: zio.aws.ivsrealtime.model.ListStagesRequest
    ): IO[AwsError, zio.aws.ivsrealtime.model.ListStagesResponse.ReadOnly] =
      asyncRequestResponse[ListStagesRequest, ListStagesResponse](
        "listStages",
        api.listStages
      )(request.buildAwsValue())
        .map(zio.aws.ivsrealtime.model.ListStagesResponse.wrap)
        .provideEnvironment(r)
    def listParticipants(
        request: zio.aws.ivsrealtime.model.ListParticipantsRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[ListParticipantsRequest, ListParticipantsResponse](
        "listParticipants",
        api.listParticipants
      )(request.buildAwsValue())
        .map(zio.aws.ivsrealtime.model.ListParticipantsResponse.wrap)
        .provideEnvironment(r)
    def deleteStage(
        request: zio.aws.ivsrealtime.model.DeleteStageRequest
    ): IO[AwsError, zio.aws.ivsrealtime.model.DeleteStageResponse.ReadOnly] =
      asyncRequestResponse[DeleteStageRequest, DeleteStageResponse](
        "deleteStage",
        api.deleteStage
      )(request.buildAwsValue())
        .map(zio.aws.ivsrealtime.model.DeleteStageResponse.wrap)
        .provideEnvironment(r)
    def createParticipantToken(
        request: zio.aws.ivsrealtime.model.CreateParticipantTokenRequest
    ): IO[
      AwsError,
      zio.aws.ivsrealtime.model.CreateParticipantTokenResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateParticipantTokenRequest,
      CreateParticipantTokenResponse
    ]("createParticipantToken", api.createParticipantToken)(
      request.buildAwsValue()
    ).map(zio.aws.ivsrealtime.model.CreateParticipantTokenResponse.wrap)
      .provideEnvironment(r)
    def listStageSessions(
        request: zio.aws.ivsrealtime.model.ListStageSessionsRequest
    ): IO[
      AwsError,
      zio.aws.ivsrealtime.model.ListStageSessionsResponse.ReadOnly
    ] =
      asyncRequestResponse[ListStageSessionsRequest, ListStageSessionsResponse](
        "listStageSessions",
        api.listStageSessions
      )(request.buildAwsValue())
        .map(zio.aws.ivsrealtime.model.ListStageSessionsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.ivsrealtime.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.ivsrealtime.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.ivsrealtime.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def getParticipant(
        request: zio.aws.ivsrealtime.model.GetParticipantRequest
    ): IO[AwsError, zio.aws.ivsrealtime.model.GetParticipantResponse.ReadOnly] =
      asyncRequestResponse[GetParticipantRequest, GetParticipantResponse](
        "getParticipant",
        api.getParticipant
      )(request.buildAwsValue())
        .map(zio.aws.ivsrealtime.model.GetParticipantResponse.wrap)
        .provideEnvironment(r)
    def createStage(
        request: zio.aws.ivsrealtime.model.CreateStageRequest
    ): IO[AwsError, zio.aws.ivsrealtime.model.CreateStageResponse.ReadOnly] =
      asyncRequestResponse[CreateStageRequest, CreateStageResponse](
        "createStage",
        api.createStage
      )(request.buildAwsValue())
        .map(zio.aws.ivsrealtime.model.CreateStageResponse.wrap)
        .provideEnvironment(r)
    def listParticipantEvents(
        request: zio.aws.ivsrealtime.model.ListParticipantEventsRequest
    ): IO[
      AwsError,
      zio.aws.ivsrealtime.model.ListParticipantEventsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListParticipantEventsRequest,
      ListParticipantEventsResponse
    ]("listParticipantEvents", api.listParticipantEvents)(
      request.buildAwsValue()
    ).map(zio.aws.ivsrealtime.model.ListParticipantEventsResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.ivsrealtime.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.ivsrealtime.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.ivsrealtime.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.ivsrealtime.model.TagResourceRequest
    ): IO[AwsError, zio.aws.ivsrealtime.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.ivsrealtime.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def getStageSession(
        request: zio.aws.ivsrealtime.model.GetStageSessionRequest
    ): IO[
      AwsError,
      zio.aws.ivsrealtime.model.GetStageSessionResponse.ReadOnly
    ] = asyncRequestResponse[GetStageSessionRequest, GetStageSessionResponse](
      "getStageSession",
      api.getStageSession
    )(request.buildAwsValue())
      .map(zio.aws.ivsrealtime.model.GetStageSessionResponse.wrap)
      .provideEnvironment(r)
  }
  def updateStage(request: zio.aws.ivsrealtime.model.UpdateStageRequest): ZIO[
    zio.aws.ivsrealtime.IvsRealTime,
    AwsError,
    zio.aws.ivsrealtime.model.UpdateStageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateStage(request))
  def disconnectParticipant(
      request: zio.aws.ivsrealtime.model.DisconnectParticipantRequest
  ): ZIO[
    zio.aws.ivsrealtime.IvsRealTime,
    AwsError,
    zio.aws.ivsrealtime.model.DisconnectParticipantResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disconnectParticipant(request))
  def getStage(request: zio.aws.ivsrealtime.model.GetStageRequest): ZIO[
    zio.aws.ivsrealtime.IvsRealTime,
    AwsError,
    zio.aws.ivsrealtime.model.GetStageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStage(request))
  def listStages(request: zio.aws.ivsrealtime.model.ListStagesRequest): ZIO[
    zio.aws.ivsrealtime.IvsRealTime,
    AwsError,
    zio.aws.ivsrealtime.model.ListStagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStages(request))
  def listParticipants(
      request: zio.aws.ivsrealtime.model.ListParticipantsRequest
  ): ZIO[zio.aws.ivsrealtime.IvsRealTime, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listParticipants(request))
  def deleteStage(request: zio.aws.ivsrealtime.model.DeleteStageRequest): ZIO[
    zio.aws.ivsrealtime.IvsRealTime,
    AwsError,
    zio.aws.ivsrealtime.model.DeleteStageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteStage(request))
  def createParticipantToken(
      request: zio.aws.ivsrealtime.model.CreateParticipantTokenRequest
  ): ZIO[
    zio.aws.ivsrealtime.IvsRealTime,
    AwsError,
    zio.aws.ivsrealtime.model.CreateParticipantTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createParticipantToken(request))
  def listStageSessions(
      request: zio.aws.ivsrealtime.model.ListStageSessionsRequest
  ): ZIO[
    zio.aws.ivsrealtime.IvsRealTime,
    AwsError,
    zio.aws.ivsrealtime.model.ListStageSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStageSessions(request))
  def untagResource(
      request: zio.aws.ivsrealtime.model.UntagResourceRequest
  ): ZIO[
    zio.aws.ivsrealtime.IvsRealTime,
    AwsError,
    zio.aws.ivsrealtime.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def getParticipant(
      request: zio.aws.ivsrealtime.model.GetParticipantRequest
  ): ZIO[
    zio.aws.ivsrealtime.IvsRealTime,
    AwsError,
    zio.aws.ivsrealtime.model.GetParticipantResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getParticipant(request))
  def createStage(request: zio.aws.ivsrealtime.model.CreateStageRequest): ZIO[
    zio.aws.ivsrealtime.IvsRealTime,
    AwsError,
    zio.aws.ivsrealtime.model.CreateStageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStage(request))
  def listParticipantEvents(
      request: zio.aws.ivsrealtime.model.ListParticipantEventsRequest
  ): ZIO[
    zio.aws.ivsrealtime.IvsRealTime,
    AwsError,
    zio.aws.ivsrealtime.model.ListParticipantEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listParticipantEvents(request))
  def listTagsForResource(
      request: zio.aws.ivsrealtime.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.ivsrealtime.IvsRealTime,
    AwsError,
    zio.aws.ivsrealtime.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: zio.aws.ivsrealtime.model.TagResourceRequest): ZIO[
    zio.aws.ivsrealtime.IvsRealTime,
    AwsError,
    zio.aws.ivsrealtime.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def getStageSession(
      request: zio.aws.ivsrealtime.model.GetStageSessionRequest
  ): ZIO[
    zio.aws.ivsrealtime.IvsRealTime,
    AwsError,
    zio.aws.ivsrealtime.model.GetStageSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStageSession(request))
}
