package zio.aws.ivsrealtime.model
import scala.jdk.CollectionConverters._
sealed trait ParticipantTokenCapability {
  def unwrap: software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenCapability
}
object ParticipantTokenCapability {
  def wrap(
      value: software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenCapability
  ): zio.aws.ivsrealtime.model.ParticipantTokenCapability = value match {
    case software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenCapability.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenCapability.PUBLISH =>
      val r = PUBLISH
      r
    case software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenCapability.SUBSCRIBE =>
      val r = SUBSCRIBE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ivsrealtime.model.ParticipantTokenCapability {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenCapability =
      software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenCapability.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLISH
      extends zio.aws.ivsrealtime.model.ParticipantTokenCapability {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenCapability =
      software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenCapability.PUBLISH
  }
  case object SUBSCRIBE
      extends zio.aws.ivsrealtime.model.ParticipantTokenCapability {
    override def unwrap
        : software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenCapability =
      software.amazon.awssdk.services.ivsrealtime.model.ParticipantTokenCapability.SUBSCRIBE
  }
}
