package zio.aws.ivsrealtime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivsrealtime.model.primitives.{
  UserId,
  Published,
  ParticipantId,
  Time
}
import scala.jdk.CollectionConverters._
final case class ParticipantSummary(
    firstJoinTime: Optional[Time] = Optional.Absent,
    participantId: Optional[ParticipantId] = Optional.Absent,
    published: Optional[Published] = Optional.Absent,
    state: Optional[zio.aws.ivsrealtime.model.ParticipantState] =
      Optional.Absent,
    userId: Optional[UserId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.ParticipantSummary = {
    import ParticipantSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.ParticipantSummary
      .builder()
      .optionallyWith(firstJoinTime.map(value => Time.unwrap(value): Instant))(
        _.firstJoinTime
      )
      .optionallyWith(
        participantId.map(value =>
          ParticipantId.unwrap(value): java.lang.String
        )
      )(_.participantId)
      .optionallyWith(
        published.map(value => Published.unwrap(value): java.lang.Boolean)
      )(_.published)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        userId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.ParticipantSummary.ReadOnly =
    zio.aws.ivsrealtime.model.ParticipantSummary.wrap(buildAwsValue())
}
object ParticipantSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.ParticipantSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.ParticipantSummary =
      zio.aws.ivsrealtime.model.ParticipantSummary(
        firstJoinTime.map(value => value),
        participantId.map(value => value),
        published.map(value => value),
        state.map(value => value),
        userId.map(value => value)
      )
    def firstJoinTime: Optional[Time]
    def participantId: Optional[ParticipantId]
    def published: Optional[Published]
    def state: Optional[zio.aws.ivsrealtime.model.ParticipantState]
    def userId: Optional[UserId]
    def getFirstJoinTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("firstJoinTime", firstJoinTime)
    def getParticipantId: ZIO[Any, AwsError, ParticipantId] =
      AwsError.unwrapOptionField("participantId", participantId)
    def getPublished: ZIO[Any, AwsError, Published] =
      AwsError.unwrapOptionField("published", published)
    def getState
        : ZIO[Any, AwsError, zio.aws.ivsrealtime.model.ParticipantState] =
      AwsError.unwrapOptionField("state", state)
    def getUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ParticipantSummary
  ) extends zio.aws.ivsrealtime.model.ParticipantSummary.ReadOnly {
    override val firstJoinTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.firstJoinTime())
      .map(value => zio.aws.ivsrealtime.model.primitives.Time(value))
    override val participantId: Optional[ParticipantId] = zio.aws.core.internal
      .optionalFromNullable(impl.participantId())
      .map(value => zio.aws.ivsrealtime.model.primitives.ParticipantId(value))
    override val published: Optional[Published] = zio.aws.core.internal
      .optionalFromNullable(impl.published())
      .map(value => zio.aws.ivsrealtime.model.primitives.Published(value))
    override val state: Optional[zio.aws.ivsrealtime.model.ParticipantState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.ivsrealtime.model.ParticipantState.wrap(value))
    override val userId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.ivsrealtime.model.primitives.UserId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ParticipantSummary
  ): zio.aws.ivsrealtime.model.ParticipantSummary.ReadOnly = new Wrapper(impl)
}
