package zio.aws.ivsrealtime.model
import zio.aws.ivsrealtime.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(tags: Map[TagKey, TagValue]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.ListTagsForResourceResponse
      .builder()
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ivsrealtime.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.ivsrealtime.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.ListTagsForResourceResponse =
      zio.aws.ivsrealtime.model.ListTagsForResourceResponse(tags)
    def tags: Map[TagKey, TagValue]
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListTagsForResourceResponse
  ) extends zio.aws.ivsrealtime.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.ivsrealtime.model.primitives
          .TagKey(key) -> zio.aws.ivsrealtime.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListTagsForResourceResponse
  ): zio.aws.ivsrealtime.model.ListTagsForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
