package zio.aws.ivsrealtime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetParticipantResponse(
    participant: Optional[zio.aws.ivsrealtime.model.Participant] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.GetParticipantResponse = {
    import GetParticipantResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.GetParticipantResponse
      .builder()
      .optionallyWith(participant.map(value => value.buildAwsValue()))(
        _.participant
      )
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.GetParticipantResponse.ReadOnly =
    zio.aws.ivsrealtime.model.GetParticipantResponse.wrap(buildAwsValue())
}
object GetParticipantResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.GetParticipantResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.GetParticipantResponse =
      zio.aws.ivsrealtime.model
        .GetParticipantResponse(participant.map(value => value.asEditable))
    def participant: Optional[zio.aws.ivsrealtime.model.Participant.ReadOnly]
    def getParticipant
        : ZIO[Any, AwsError, zio.aws.ivsrealtime.model.Participant.ReadOnly] =
      AwsError.unwrapOptionField("participant", participant)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.GetParticipantResponse
  ) extends zio.aws.ivsrealtime.model.GetParticipantResponse.ReadOnly {
    override val participant
        : Optional[zio.aws.ivsrealtime.model.Participant.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participant())
        .map(value => zio.aws.ivsrealtime.model.Participant.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.GetParticipantResponse
  ): zio.aws.ivsrealtime.model.GetParticipantResponse.ReadOnly = new Wrapper(
    impl
  )
}
