package zio.aws.ivsrealtime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivsrealtime.model.primitives.{
  UserId,
  StageSessionId,
  StageArn,
  PaginationToken,
  MaxParticipantResults,
  Published
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListParticipantsRequest(
    filterByPublished: Optional[Published] = Optional.Absent,
    filterByState: Optional[zio.aws.ivsrealtime.model.ParticipantState] =
      Optional.Absent,
    filterByUserId: Optional[UserId] = Optional.Absent,
    maxResults: Optional[MaxParticipantResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    sessionId: StageSessionId,
    stageArn: StageArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsRequest = {
    import ListParticipantsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsRequest
      .builder()
      .optionallyWith(
        filterByPublished.map(value =>
          Published.unwrap(value): java.lang.Boolean
        )
      )(_.filterByPublished)
      .optionallyWith(filterByState.map(value => value.unwrap))(_.filterByState)
      .optionallyWith(
        filterByUserId.map(value => UserId.unwrap(value): java.lang.String)
      )(_.filterByUserId)
      .optionallyWith(
        maxResults.map(value => MaxParticipantResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .sessionId(StageSessionId.unwrap(sessionId): java.lang.String)
      .stageArn(StageArn.unwrap(stageArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.ListParticipantsRequest.ReadOnly =
    zio.aws.ivsrealtime.model.ListParticipantsRequest.wrap(buildAwsValue())
}
object ListParticipantsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.ListParticipantsRequest =
      zio.aws.ivsrealtime.model.ListParticipantsRequest(
        filterByPublished.map(value => value),
        filterByState.map(value => value),
        filterByUserId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        sessionId,
        stageArn
      )
    def filterByPublished: Optional[Published]
    def filterByState: Optional[zio.aws.ivsrealtime.model.ParticipantState]
    def filterByUserId: Optional[UserId]
    def maxResults: Optional[MaxParticipantResults]
    def nextToken: Optional[PaginationToken]
    def sessionId: StageSessionId
    def stageArn: StageArn
    def getFilterByPublished: ZIO[Any, AwsError, Published] =
      AwsError.unwrapOptionField("filterByPublished", filterByPublished)
    def getFilterByState
        : ZIO[Any, AwsError, zio.aws.ivsrealtime.model.ParticipantState] =
      AwsError.unwrapOptionField("filterByState", filterByState)
    def getFilterByUserId: ZIO[Any, AwsError, UserId] =
      AwsError.unwrapOptionField("filterByUserId", filterByUserId)
    def getMaxResults: ZIO[Any, AwsError, MaxParticipantResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSessionId: ZIO[Any, Nothing, StageSessionId] = ZIO.succeed(sessionId)
    def getStageArn: ZIO[Any, Nothing, StageArn] = ZIO.succeed(stageArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsRequest
  ) extends zio.aws.ivsrealtime.model.ListParticipantsRequest.ReadOnly {
    override val filterByPublished: Optional[Published] = zio.aws.core.internal
      .optionalFromNullable(impl.filterByPublished())
      .map(value => zio.aws.ivsrealtime.model.primitives.Published(value))
    override val filterByState
        : Optional[zio.aws.ivsrealtime.model.ParticipantState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filterByState())
        .map(value => zio.aws.ivsrealtime.model.ParticipantState.wrap(value))
    override val filterByUserId: Optional[UserId] = zio.aws.core.internal
      .optionalFromNullable(impl.filterByUserId())
      .map(value => zio.aws.ivsrealtime.model.primitives.UserId(value))
    override val maxResults: Optional[MaxParticipantResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives.MaxParticipantResults(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivsrealtime.model.primitives.PaginationToken(value))
    override val sessionId: StageSessionId =
      zio.aws.ivsrealtime.model.primitives.StageSessionId(impl.sessionId())
    override val stageArn: StageArn =
      zio.aws.ivsrealtime.model.primitives.StageArn(impl.stageArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsRequest
  ): zio.aws.ivsrealtime.model.ListParticipantsRequest.ReadOnly = new Wrapper(
    impl
  )
}
