package zio.aws.ivsrealtime.model
import zio.aws.ivsrealtime.model.primitives.{
  StageSessionId,
  TagValue,
  StageArn,
  StageName,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StageSummary(
    activeSessionId: Optional[StageSessionId] = Optional.Absent,
    arn: StageArn,
    name: Optional[StageName] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.StageSummary = {
    import StageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.StageSummary
      .builder()
      .optionallyWith(
        activeSessionId.map(value =>
          StageSessionId.unwrap(value): java.lang.String
        )
      )(_.activeSessionId)
      .arn(StageArn.unwrap(arn): java.lang.String)
      .optionallyWith(
        name.map(value => StageName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.StageSummary.ReadOnly =
    zio.aws.ivsrealtime.model.StageSummary.wrap(buildAwsValue())
}
object StageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.StageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.StageSummary =
      zio.aws.ivsrealtime.model.StageSummary(
        activeSessionId.map(value => value),
        arn,
        name.map(value => value),
        tags.map(value => value)
      )
    def activeSessionId: Optional[StageSessionId]
    def arn: StageArn
    def name: Optional[StageName]
    def tags: Optional[Map[TagKey, TagValue]]
    def getActiveSessionId: ZIO[Any, AwsError, StageSessionId] =
      AwsError.unwrapOptionField("activeSessionId", activeSessionId)
    def getArn: ZIO[Any, Nothing, StageArn] = ZIO.succeed(arn)
    def getName: ZIO[Any, AwsError, StageName] =
      AwsError.unwrapOptionField("name", name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.StageSummary
  ) extends zio.aws.ivsrealtime.model.StageSummary.ReadOnly {
    override val activeSessionId: Optional[StageSessionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeSessionId())
        .map(value =>
          zio.aws.ivsrealtime.model.primitives.StageSessionId(value)
        )
    override val arn: StageArn =
      zio.aws.ivsrealtime.model.primitives.StageArn(impl.arn())
    override val name: Optional[StageName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ivsrealtime.model.primitives.StageName(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivsrealtime.model.primitives.TagKey(
              key
            ) -> zio.aws.ivsrealtime.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.StageSummary
  ): zio.aws.ivsrealtime.model.StageSummary.ReadOnly = new Wrapper(impl)
}
