package zio.aws.ivsrealtime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivsrealtime.model.primitives.{PaginationToken, MaxStageResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStagesRequest(
    maxResults: Optional[MaxStageResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.ListStagesRequest = {
    import ListStagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.ListStagesRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxStageResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.ListStagesRequest.ReadOnly =
    zio.aws.ivsrealtime.model.ListStagesRequest.wrap(buildAwsValue())
}
object ListStagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.ListStagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.ListStagesRequest =
      zio.aws.ivsrealtime.model.ListStagesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxStageResults]
    def nextToken: Optional[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, MaxStageResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListStagesRequest
  ) extends zio.aws.ivsrealtime.model.ListStagesRequest.ReadOnly {
    override val maxResults: Optional[MaxStageResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ivsrealtime.model.primitives.MaxStageResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivsrealtime.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListStagesRequest
  ): zio.aws.ivsrealtime.model.ListStagesRequest.ReadOnly = new Wrapper(impl)
}
