package zio.aws.ivsrealtime.model
import zio.aws.ivsrealtime.model.primitives.StageArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteStageRequest(arn: StageArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.DeleteStageRequest = {
    import DeleteStageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.DeleteStageRequest
      .builder()
      .arn(StageArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.DeleteStageRequest.ReadOnly =
    zio.aws.ivsrealtime.model.DeleteStageRequest.wrap(buildAwsValue())
}
object DeleteStageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.DeleteStageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.DeleteStageRequest =
      zio.aws.ivsrealtime.model.DeleteStageRequest(arn)
    def arn: StageArn
    def getArn: ZIO[Any, Nothing, StageArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.DeleteStageRequest
  ) extends zio.aws.ivsrealtime.model.DeleteStageRequest.ReadOnly {
    override val arn: StageArn =
      zio.aws.ivsrealtime.model.primitives.StageArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.DeleteStageRequest
  ): zio.aws.ivsrealtime.model.DeleteStageRequest.ReadOnly = new Wrapper(impl)
}
