package zio.aws.ivsrealtime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivsrealtime.model.primitives.{StageSessionId, Time}
import scala.jdk.CollectionConverters._
final case class StageSessionSummary(
    endTime: Optional[Time] = Optional.Absent,
    sessionId: Optional[StageSessionId] = Optional.Absent,
    startTime: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.StageSessionSummary = {
    import StageSessionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.StageSessionSummary
      .builder()
      .optionallyWith(endTime.map(value => Time.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(
        sessionId.map(value => StageSessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(startTime.map(value => Time.unwrap(value): Instant))(
        _.startTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.StageSessionSummary.ReadOnly =
    zio.aws.ivsrealtime.model.StageSessionSummary.wrap(buildAwsValue())
}
object StageSessionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.StageSessionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.StageSessionSummary =
      zio.aws.ivsrealtime.model.StageSessionSummary(
        endTime.map(value => value),
        sessionId.map(value => value),
        startTime.map(value => value)
      )
    def endTime: Optional[Time]
    def sessionId: Optional[StageSessionId]
    def startTime: Optional[Time]
    def getEndTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getSessionId: ZIO[Any, AwsError, StageSessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getStartTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("startTime", startTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.StageSessionSummary
  ) extends zio.aws.ivsrealtime.model.StageSessionSummary.ReadOnly {
    override val endTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.ivsrealtime.model.primitives.Time(value))
    override val sessionId: Optional[StageSessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.ivsrealtime.model.primitives.StageSessionId(value))
    override val startTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ivsrealtime.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.StageSessionSummary
  ): zio.aws.ivsrealtime.model.StageSessionSummary.ReadOnly = new Wrapper(impl)
}
