package zio.aws.ivsrealtime.model
import zio.aws.ivsrealtime.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListParticipantsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    participants: Iterable[zio.aws.ivsrealtime.model.ParticipantSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsResponse = {
    import ListParticipantsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .participants(participants.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.ListParticipantsResponse.ReadOnly =
    zio.aws.ivsrealtime.model.ListParticipantsResponse.wrap(buildAwsValue())
}
object ListParticipantsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.ListParticipantsResponse =
      zio.aws.ivsrealtime.model.ListParticipantsResponse(
        nextToken.map(value => value),
        participants.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[PaginationToken]
    def participants
        : List[zio.aws.ivsrealtime.model.ParticipantSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getParticipants: ZIO[Any, Nothing, List[
      zio.aws.ivsrealtime.model.ParticipantSummary.ReadOnly
    ]] = ZIO.succeed(participants)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsResponse
  ) extends zio.aws.ivsrealtime.model.ListParticipantsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivsrealtime.model.primitives.PaginationToken(value))
    override val participants
        : List[zio.aws.ivsrealtime.model.ParticipantSummary.ReadOnly] = impl
      .participants()
      .asScala
      .map { item =>
        zio.aws.ivsrealtime.model.ParticipantSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListParticipantsResponse
  ): zio.aws.ivsrealtime.model.ListParticipantsResponse.ReadOnly = new Wrapper(
    impl
  )
}
