package zio.aws.ivsrealtime.model
import zio.aws.ivsrealtime.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListParticipantEventsResponse(
    events: Iterable[zio.aws.ivsrealtime.model.Event],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsResponse = {
    import ListParticipantEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsResponse
      .builder()
      .events(events.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ivsrealtime.model.ListParticipantEventsResponse.ReadOnly =
    zio.aws.ivsrealtime.model.ListParticipantEventsResponse
      .wrap(buildAwsValue())
}
object ListParticipantEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.ListParticipantEventsResponse =
      zio.aws.ivsrealtime.model.ListParticipantEventsResponse(
        events.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def events: List[zio.aws.ivsrealtime.model.Event.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getEvents
        : ZIO[Any, Nothing, List[zio.aws.ivsrealtime.model.Event.ReadOnly]] =
      ZIO.succeed(events)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsResponse
  ) extends zio.aws.ivsrealtime.model.ListParticipantEventsResponse.ReadOnly {
    override val events: List[zio.aws.ivsrealtime.model.Event.ReadOnly] = impl
      .events()
      .asScala
      .map { item =>
        zio.aws.ivsrealtime.model.Event.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivsrealtime.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.ListParticipantEventsResponse
  ): zio.aws.ivsrealtime.model.ListParticipantEventsResponse.ReadOnly =
    new Wrapper(impl)
}
