package zio.aws.ivsrealtime.model
import zio.aws.ivsrealtime.model.primitives.{
  StageArn,
  StageSessionId,
  ParticipantId
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetParticipantRequest(
    participantId: ParticipantId,
    sessionId: StageSessionId,
    stageArn: StageArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivsrealtime.model.GetParticipantRequest = {
    import GetParticipantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivsrealtime.model.GetParticipantRequest
      .builder()
      .participantId(ParticipantId.unwrap(participantId): java.lang.String)
      .sessionId(StageSessionId.unwrap(sessionId): java.lang.String)
      .stageArn(StageArn.unwrap(stageArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivsrealtime.model.GetParticipantRequest.ReadOnly =
    zio.aws.ivsrealtime.model.GetParticipantRequest.wrap(buildAwsValue())
}
object GetParticipantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivsrealtime.model.GetParticipantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivsrealtime.model.GetParticipantRequest =
      zio.aws.ivsrealtime.model
        .GetParticipantRequest(participantId, sessionId, stageArn)
    def participantId: ParticipantId
    def sessionId: StageSessionId
    def stageArn: StageArn
    def getParticipantId: ZIO[Any, Nothing, ParticipantId] =
      ZIO.succeed(participantId)
    def getSessionId: ZIO[Any, Nothing, StageSessionId] = ZIO.succeed(sessionId)
    def getStageArn: ZIO[Any, Nothing, StageArn] = ZIO.succeed(stageArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivsrealtime.model.GetParticipantRequest
  ) extends zio.aws.ivsrealtime.model.GetParticipantRequest.ReadOnly {
    override val participantId: ParticipantId =
      zio.aws.ivsrealtime.model.primitives.ParticipantId(impl.participantId())
    override val sessionId: StageSessionId =
      zio.aws.ivsrealtime.model.primitives.StageSessionId(impl.sessionId())
    override val stageArn: StageArn =
      zio.aws.ivsrealtime.model.primitives.StageArn(impl.stageArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivsrealtime.model.GetParticipantRequest
  ): zio.aws.ivsrealtime.model.GetParticipantRequest.ReadOnly = new Wrapper(
    impl
  )
}
