package zio.aws.ivschat.model
import zio.aws.ivschat.model.primitives.{
  Time,
  LoggingConfigurationIdentifier,
  RoomMaxMessageRatePerSecond,
  TagValue,
  RoomMaxMessageLength,
  RoomID,
  RoomArn,
  RoomName,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateRoomResponse(
    arn: Optional[RoomArn] = Optional.Absent,
    createTime: Optional[Time] = Optional.Absent,
    id: Optional[RoomID] = Optional.Absent,
    loggingConfigurationIdentifiers: Optional[
      Iterable[LoggingConfigurationIdentifier]
    ] = Optional.Absent,
    maximumMessageLength: Optional[RoomMaxMessageLength] = Optional.Absent,
    maximumMessageRatePerSecond: Optional[RoomMaxMessageRatePerSecond] =
      Optional.Absent,
    messageReviewHandler: Optional[zio.aws.ivschat.model.MessageReviewHandler] =
      Optional.Absent,
    name: Optional[RoomName] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    updateTime: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.UpdateRoomResponse = {
    import UpdateRoomResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.UpdateRoomResponse
      .builder()
      .optionallyWith(
        arn.map(value => RoomArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(createTime.map(value => Time.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(id.map(value => RoomID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        loggingConfigurationIdentifiers.map(value =>
          value.map { item =>
            LoggingConfigurationIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.loggingConfigurationIdentifiers)
      .optionallyWith(
        maximumMessageLength.map(value =>
          RoomMaxMessageLength.unwrap(value): Integer
        )
      )(_.maximumMessageLength)
      .optionallyWith(
        maximumMessageRatePerSecond.map(value =>
          RoomMaxMessageRatePerSecond.unwrap(value): Integer
        )
      )(_.maximumMessageRatePerSecond)
      .optionallyWith(messageReviewHandler.map(value => value.buildAwsValue()))(
        _.messageReviewHandler
      )
      .optionallyWith(
        name.map(value => RoomName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(updateTime.map(value => Time.unwrap(value): Instant))(
        _.updateTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.UpdateRoomResponse.ReadOnly =
    zio.aws.ivschat.model.UpdateRoomResponse.wrap(buildAwsValue())
}
object UpdateRoomResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.UpdateRoomResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.UpdateRoomResponse =
      zio.aws.ivschat.model.UpdateRoomResponse(
        arn.map(value => value),
        createTime.map(value => value),
        id.map(value => value),
        loggingConfigurationIdentifiers.map(value => value),
        maximumMessageLength.map(value => value),
        maximumMessageRatePerSecond.map(value => value),
        messageReviewHandler.map(value => value.asEditable),
        name.map(value => value),
        tags.map(value => value),
        updateTime.map(value => value)
      )
    def arn: Optional[RoomArn]
    def createTime: Optional[Time]
    def id: Optional[RoomID]
    def loggingConfigurationIdentifiers
        : Optional[List[LoggingConfigurationIdentifier]]
    def maximumMessageLength: Optional[RoomMaxMessageLength]
    def maximumMessageRatePerSecond: Optional[RoomMaxMessageRatePerSecond]
    def messageReviewHandler
        : Optional[zio.aws.ivschat.model.MessageReviewHandler.ReadOnly]
    def name: Optional[RoomName]
    def tags: Optional[Map[TagKey, TagValue]]
    def updateTime: Optional[Time]
    def getArn: ZIO[Any, AwsError, RoomArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreateTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getId: ZIO[Any, AwsError, RoomID] = AwsError.unwrapOptionField("id", id)
    def getLoggingConfigurationIdentifiers
        : ZIO[Any, AwsError, List[LoggingConfigurationIdentifier]] =
      AwsError.unwrapOptionField(
        "loggingConfigurationIdentifiers",
        loggingConfigurationIdentifiers
      )
    def getMaximumMessageLength: ZIO[Any, AwsError, RoomMaxMessageLength] =
      AwsError.unwrapOptionField("maximumMessageLength", maximumMessageLength)
    def getMaximumMessageRatePerSecond
        : ZIO[Any, AwsError, RoomMaxMessageRatePerSecond] =
      AwsError.unwrapOptionField(
        "maximumMessageRatePerSecond",
        maximumMessageRatePerSecond
      )
    def getMessageReviewHandler: ZIO[
      Any,
      AwsError,
      zio.aws.ivschat.model.MessageReviewHandler.ReadOnly
    ] = AwsError.unwrapOptionField("messageReviewHandler", messageReviewHandler)
    def getName: ZIO[Any, AwsError, RoomName] =
      AwsError.unwrapOptionField("name", name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdateTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("updateTime", updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.UpdateRoomResponse
  ) extends zio.aws.ivschat.model.UpdateRoomResponse.ReadOnly {
    override val arn: Optional[RoomArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.ivschat.model.primitives.RoomArn(value))
    override val createTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.ivschat.model.primitives.Time(value))
    override val id: Optional[RoomID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.ivschat.model.primitives.RoomID(value))
    override val loggingConfigurationIdentifiers
        : Optional[List[LoggingConfigurationIdentifier]] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingConfigurationIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ivschat.model.primitives.LoggingConfigurationIdentifier(item)
        }.toList
      )
    override val maximumMessageLength: Optional[RoomMaxMessageLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumMessageLength())
        .map(value =>
          zio.aws.ivschat.model.primitives.RoomMaxMessageLength(value)
        )
    override val maximumMessageRatePerSecond
        : Optional[RoomMaxMessageRatePerSecond] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumMessageRatePerSecond())
      .map(value =>
        zio.aws.ivschat.model.primitives.RoomMaxMessageRatePerSecond(value)
      )
    override val messageReviewHandler
        : Optional[zio.aws.ivschat.model.MessageReviewHandler.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageReviewHandler())
        .map(value => zio.aws.ivschat.model.MessageReviewHandler.wrap(value))
    override val name: Optional[RoomName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ivschat.model.primitives.RoomName(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivschat.model.primitives
              .TagKey(key) -> zio.aws.ivschat.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val updateTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.updateTime())
      .map(value => zio.aws.ivschat.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.UpdateRoomResponse
  ): zio.aws.ivschat.model.UpdateRoomResponse.ReadOnly = new Wrapper(impl)
}
