package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.ivschat.model.primitives.{UserID, RoomIdentifier, Reason}
import scala.jdk.CollectionConverters.*
final case class DisconnectUserRequest(
    reason: Optional[Reason] = Optional.Absent,
    roomIdentifier: RoomIdentifier,
    userId: UserID
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.DisconnectUserRequest = {
    import DisconnectUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.DisconnectUserRequest
      .builder()
      .optionallyWith(
        reason.map(value => Reason.unwrap(value): java.lang.String)
      )(_.reason)
      .roomIdentifier(RoomIdentifier.unwrap(roomIdentifier): java.lang.String)
      .userId(UserID.unwrap(userId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.DisconnectUserRequest.ReadOnly =
    zio.aws.ivschat.model.DisconnectUserRequest.wrap(buildAwsValue())
}
object DisconnectUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.DisconnectUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.DisconnectUserRequest =
      zio.aws.ivschat.model.DisconnectUserRequest(
        reason.map(value => value),
        roomIdentifier,
        userId
      )
    def reason: Optional[Reason]
    def roomIdentifier: RoomIdentifier
    def userId: UserID
    def getReason: ZIO[Any, AwsError, Reason] =
      AwsError.unwrapOptionField("reason", reason)
    def getRoomIdentifier: ZIO[Any, Nothing, RoomIdentifier] =
      ZIO.succeed(roomIdentifier)
    def getUserId: ZIO[Any, Nothing, UserID] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.DisconnectUserRequest
  ) extends zio.aws.ivschat.model.DisconnectUserRequest.ReadOnly {
    override val reason: Optional[Reason] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.ivschat.model.primitives.Reason(value))
    override val roomIdentifier: RoomIdentifier =
      zio.aws.ivschat.model.primitives.RoomIdentifier(impl.roomIdentifier())
    override val userId: UserID =
      zio.aws.ivschat.model.primitives.UserID(impl.userId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.DisconnectUserRequest
  ): zio.aws.ivschat.model.DisconnectUserRequest.ReadOnly = new Wrapper(impl)
}
