package zio.aws.ivschat.model
import scala.jdk.CollectionConverters.*
sealed trait ChatTokenCapability {
  def unwrap: software.amazon.awssdk.services.ivschat.model.ChatTokenCapability
}
object ChatTokenCapability {
  def wrap(
      value: software.amazon.awssdk.services.ivschat.model.ChatTokenCapability
  ): zio.aws.ivschat.model.ChatTokenCapability = value match {
    case software.amazon.awssdk.services.ivschat.model.ChatTokenCapability.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivschat.model.ChatTokenCapability.SEND_MESSAGE =>
      val r = SEND_MESSAGE
      r
    case software.amazon.awssdk.services.ivschat.model.ChatTokenCapability.DISCONNECT_USER =>
      val r = DISCONNECT_USER
      r
    case software.amazon.awssdk.services.ivschat.model.ChatTokenCapability.DELETE_MESSAGE =>
      val r = DELETE_MESSAGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ivschat.model.ChatTokenCapability {
    override def unwrap
        : software.amazon.awssdk.services.ivschat.model.ChatTokenCapability =
      software.amazon.awssdk.services.ivschat.model.ChatTokenCapability.UNKNOWN_TO_SDK_VERSION
  }
  case object SEND_MESSAGE extends zio.aws.ivschat.model.ChatTokenCapability {
    override def unwrap
        : software.amazon.awssdk.services.ivschat.model.ChatTokenCapability =
      software.amazon.awssdk.services.ivschat.model.ChatTokenCapability.SEND_MESSAGE
  }
  case object DISCONNECT_USER
      extends zio.aws.ivschat.model.ChatTokenCapability {
    override def unwrap
        : software.amazon.awssdk.services.ivschat.model.ChatTokenCapability =
      software.amazon.awssdk.services.ivschat.model.ChatTokenCapability.DISCONNECT_USER
  }
  case object DELETE_MESSAGE extends zio.aws.ivschat.model.ChatTokenCapability {
    override def unwrap
        : software.amazon.awssdk.services.ivschat.model.ChatTokenCapability =
      software.amazon.awssdk.services.ivschat.model.ChatTokenCapability.DELETE_MESSAGE
  }
}
