package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.ivschat.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListRoomsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    rooms: Iterable[zio.aws.ivschat.model.RoomSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.ListRoomsResponse = {
    import ListRoomsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.ListRoomsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .rooms(rooms.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.ListRoomsResponse.ReadOnly =
    zio.aws.ivschat.model.ListRoomsResponse.wrap(buildAwsValue())
}
object ListRoomsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.ListRoomsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.ListRoomsResponse =
      zio.aws.ivschat.model.ListRoomsResponse(
        nextToken.map(value => value),
        rooms.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[PaginationToken]
    def rooms: List[zio.aws.ivschat.model.RoomSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRooms
        : ZIO[Any, Nothing, List[zio.aws.ivschat.model.RoomSummary.ReadOnly]] =
      ZIO.succeed(rooms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.ListRoomsResponse
  ) extends zio.aws.ivschat.model.ListRoomsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivschat.model.primitives.PaginationToken(value))
    override val rooms: List[zio.aws.ivschat.model.RoomSummary.ReadOnly] = impl
      .rooms()
      .asScala
      .map { item =>
        zio.aws.ivschat.model.RoomSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.ListRoomsResponse
  ): zio.aws.ivschat.model.ListRoomsResponse.ReadOnly = new Wrapper(impl)
}
