package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ivschat.model.primitives.RoomIdentifier
import scala.jdk.CollectionConverters.*
final case class GetRoomRequest(identifier: RoomIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.GetRoomRequest = {
    import GetRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.GetRoomRequest
      .builder()
      .identifier(RoomIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.GetRoomRequest.ReadOnly =
    zio.aws.ivschat.model.GetRoomRequest.wrap(buildAwsValue())
}
object GetRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.GetRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.GetRoomRequest =
      zio.aws.ivschat.model.GetRoomRequest(identifier)
    def identifier: RoomIdentifier
    def getIdentifier: ZIO[Any, Nothing, RoomIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.GetRoomRequest
  ) extends zio.aws.ivschat.model.GetRoomRequest.ReadOnly {
    override val identifier: RoomIdentifier =
      zio.aws.ivschat.model.primitives.RoomIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.GetRoomRequest
  ): zio.aws.ivschat.model.GetRoomRequest.ReadOnly = new Wrapper(impl)
}
