package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ivschat.model.primitives.DeliveryStreamName
import scala.jdk.CollectionConverters.*
final case class FirehoseDestinationConfiguration(
    deliveryStreamName: DeliveryStreamName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.FirehoseDestinationConfiguration = {
    import FirehoseDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.FirehoseDestinationConfiguration
      .builder()
      .deliveryStreamName(
        DeliveryStreamName.unwrap(deliveryStreamName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ivschat.model.FirehoseDestinationConfiguration.ReadOnly =
    zio.aws.ivschat.model.FirehoseDestinationConfiguration.wrap(buildAwsValue())
}
object FirehoseDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.FirehoseDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.FirehoseDestinationConfiguration =
      zio.aws.ivschat.model.FirehoseDestinationConfiguration(deliveryStreamName)
    def deliveryStreamName: DeliveryStreamName
    def getDeliveryStreamName: ZIO[Any, Nothing, DeliveryStreamName] =
      ZIO.succeed(deliveryStreamName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.FirehoseDestinationConfiguration
  ) extends zio.aws.ivschat.model.FirehoseDestinationConfiguration.ReadOnly {
    override val deliveryStreamName: DeliveryStreamName =
      zio.aws.ivschat.model.primitives
        .DeliveryStreamName(impl.deliveryStreamName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.FirehoseDestinationConfiguration
  ): zio.aws.ivschat.model.FirehoseDestinationConfiguration.ReadOnly =
    new Wrapper(impl)
}
