package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.ivschat.model.primitives.LambdaArn
import scala.jdk.CollectionConverters.*
final case class MessageReviewHandler(
    fallbackResult: Optional[zio.aws.ivschat.model.FallbackResult] =
      Optional.Absent,
    uri: Optional[LambdaArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.MessageReviewHandler = {
    import MessageReviewHandler.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.MessageReviewHandler
      .builder()
      .optionallyWith(fallbackResult.map(value => value.unwrap))(
        _.fallbackResult
      )
      .optionallyWith(
        uri.map(value => LambdaArn.unwrap(value): java.lang.String)
      )(_.uri)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.MessageReviewHandler.ReadOnly =
    zio.aws.ivschat.model.MessageReviewHandler.wrap(buildAwsValue())
}
object MessageReviewHandler {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.MessageReviewHandler
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.MessageReviewHandler =
      zio.aws.ivschat.model.MessageReviewHandler(
        fallbackResult.map(value => value),
        uri.map(value => value)
      )
    def fallbackResult: Optional[zio.aws.ivschat.model.FallbackResult]
    def uri: Optional[LambdaArn]
    def getFallbackResult
        : ZIO[Any, AwsError, zio.aws.ivschat.model.FallbackResult] =
      AwsError.unwrapOptionField("fallbackResult", fallbackResult)
    def getUri: ZIO[Any, AwsError, LambdaArn] =
      AwsError.unwrapOptionField("uri", uri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.MessageReviewHandler
  ) extends zio.aws.ivschat.model.MessageReviewHandler.ReadOnly {
    override val fallbackResult
        : Optional[zio.aws.ivschat.model.FallbackResult] = zio.aws.core.internal
      .optionalFromNullable(impl.fallbackResult())
      .map(value => zio.aws.ivschat.model.FallbackResult.wrap(value))
    override val uri: Optional[LambdaArn] = zio.aws.core.internal
      .optionalFromNullable(impl.uri())
      .map(value => zio.aws.ivschat.model.primitives.LambdaArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.MessageReviewHandler
  ): zio.aws.ivschat.model.MessageReviewHandler.ReadOnly = new Wrapper(impl)
}
